/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEbsEncryptionByDefaultResponse extends Ec2Response implements
        ToCopyableBuilder<GetEbsEncryptionByDefaultResponse.Builder, GetEbsEncryptionByDefaultResponse> {
    private static final SdkField<Boolean> EBS_ENCRYPTION_BY_DEFAULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetEbsEncryptionByDefaultResponse::ebsEncryptionByDefault))
            .setter(setter(Builder::ebsEncryptionByDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsEncryptionByDefault")
                    .unmarshallLocationName("ebsEncryptionByDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EBS_ENCRYPTION_BY_DEFAULT_FIELD));

    private final Boolean ebsEncryptionByDefault;

    private GetEbsEncryptionByDefaultResponse(BuilderImpl builder) {
        super(builder);
        this.ebsEncryptionByDefault = builder.ebsEncryptionByDefault;
    }

    /**
     * <p>
     * Indicates whether default encryption for EBS volumes is enabled or disabled.
     * </p>
     * 
     * @return Indicates whether default encryption for EBS volumes is enabled or disabled.
     */
    public Boolean ebsEncryptionByDefault() {
        return ebsEncryptionByDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsEncryptionByDefault());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEbsEncryptionByDefaultResponse)) {
            return false;
        }
        GetEbsEncryptionByDefaultResponse other = (GetEbsEncryptionByDefaultResponse) obj;
        return Objects.equals(ebsEncryptionByDefault(), other.ebsEncryptionByDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetEbsEncryptionByDefaultResponse").add("EbsEncryptionByDefault", ebsEncryptionByDefault())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsEncryptionByDefault":
            return Optional.ofNullable(clazz.cast(ebsEncryptionByDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEbsEncryptionByDefaultResponse, T> g) {
        return obj -> g.apply((GetEbsEncryptionByDefaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetEbsEncryptionByDefaultResponse> {
        /**
         * <p>
         * Indicates whether default encryption for EBS volumes is enabled or disabled.
         * </p>
         * 
         * @param ebsEncryptionByDefault
         *        Indicates whether default encryption for EBS volumes is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsEncryptionByDefault(Boolean ebsEncryptionByDefault);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean ebsEncryptionByDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEbsEncryptionByDefaultResponse model) {
            super(model);
            ebsEncryptionByDefault(model.ebsEncryptionByDefault);
        }

        public final Boolean getEbsEncryptionByDefault() {
            return ebsEncryptionByDefault;
        }

        @Override
        public final Builder ebsEncryptionByDefault(Boolean ebsEncryptionByDefault) {
            this.ebsEncryptionByDefault = ebsEncryptionByDefault;
            return this;
        }

        public final void setEbsEncryptionByDefault(Boolean ebsEncryptionByDefault) {
            this.ebsEncryptionByDefault = ebsEncryptionByDefault;
        }

        @Override
        public GetEbsEncryptionByDefaultResponse build() {
            return new GetEbsEncryptionByDefaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
