/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEbsDefaultKmsKeyIdRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyEbsDefaultKmsKeyIdRequest.Builder, ModifyEbsDefaultKmsKeyIdRequest> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEbsDefaultKmsKeyIdRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId")
                    .unmarshallLocationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD));

    private final String kmsKeyId;

    private ModifyEbsDefaultKmsKeyIdRequest(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * An identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) to use to encrypt the
     * volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not specified,
     * the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must
     * also be set.
     * </p>
     * <p>
     * The CMK identifier may be provided in any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the CMK,
     * the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example,
     * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
     * CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For example,
     * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) to use to encrypt
     *         the volume. This parameter is only required if you want to use a non-default CMK; if this parameter is
     *         not specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the
     *         <code>Encrypted</code> flag must also be set. </p>
     *         <p>
     *         The CMK identifier may be provided in any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
     *         the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For
     *         example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
     *         Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the
     *         CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
     *         </p>
     *         </li>
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEbsDefaultKmsKeyIdRequest)) {
            return false;
        }
        ModifyEbsDefaultKmsKeyIdRequest other = (ModifyEbsDefaultKmsKeyIdRequest) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyEbsDefaultKmsKeyIdRequest").add("KmsKeyId", kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEbsDefaultKmsKeyIdRequest, T> g) {
        return obj -> g.apply((ModifyEbsDefaultKmsKeyIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyEbsDefaultKmsKeyIdRequest> {
        /**
         * <p>
         * An identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) to use to encrypt the
         * volume. This parameter is only required if you want to use a non-default CMK; if this parameter is not
         * specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the
         * <code>Encrypted</code> flag must also be set.
         * </p>
         * <p>
         * The CMK identifier may be provided in any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of the
         * CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example,
         * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region of
         * the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the CMK alias. For
         * example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        An identifier for the AWS Key Management Service (AWS KMS) customer master key (CMK) to use to encrypt
         *        the volume. This parameter is only required if you want to use a non-default CMK; if this parameter is
         *        not specified, the default CMK for EBS is used. If a <code>KmsKeyId</code> is specified, the
         *        <code>Encrypted</code> flag must also be set. </p>
         *        <p>
         *        The CMK identifier may be provided in any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key ID. The ID ARN contains the <code>arn:aws:kms</code> namespace, followed by the Region
         *        of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID.
         *        For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN using key alias. The alias ARN contains the <code>arn:aws:kms</code> namespace, followed by the
         *        Region of the CMK, the AWS account ID of the CMK owner, the <code>alias</code> namespace, and then the
         *        CMK alias. For example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:alias/<i>ExampleAlias</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEbsDefaultKmsKeyIdRequest model) {
            super(model);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEbsDefaultKmsKeyIdRequest build() {
            return new ModifyEbsDefaultKmsKeyIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
