/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstancesListing implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstancesListing.Builder, ReservedInstancesListing> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesListing::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReservedInstancesListing::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate")
                    .unmarshallLocationName("createDate").build()).build();

    private static final SdkField<List<InstanceCount>> INSTANCE_COUNTS_FIELD = SdkField
            .<List<InstanceCount>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesListing::instanceCounts))
            .setter(setter(Builder::instanceCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCounts")
                    .unmarshallLocationName("instanceCounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PriceSchedule>> PRICE_SCHEDULES_FIELD = SdkField
            .<List<PriceSchedule>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesListing::priceSchedules))
            .setter(setter(Builder::priceSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules")
                    .unmarshallLocationName("priceSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PriceSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PriceSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesListing::reservedInstancesId))
            .setter(setter(Builder::reservedInstancesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId")
                    .unmarshallLocationName("reservedInstancesId").build()).build();

    private static final SdkField<String> RESERVED_INSTANCES_LISTING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesListing::reservedInstancesListingId))
            .setter(setter(Builder::reservedInstancesListingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingId")
                    .unmarshallLocationName("reservedInstancesListingId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesListing::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstancesListing::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("statusMessage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ReservedInstancesListing::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ReservedInstancesListing::updateDate))
            .setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate")
                    .unmarshallLocationName("updateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CREATE_DATE_FIELD, INSTANCE_COUNTS_FIELD, PRICE_SCHEDULES_FIELD, RESERVED_INSTANCES_ID_FIELD,
            RESERVED_INSTANCES_LISTING_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD, UPDATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientToken;

    private final Instant createDate;

    private final List<InstanceCount> instanceCounts;

    private final List<PriceSchedule> priceSchedules;

    private final String reservedInstancesId;

    private final String reservedInstancesListingId;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private final Instant updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time the listing was created.
     * </p>
     * 
     * @return The time the listing was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The number of instances in this state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of instances in this state.
     */
    public List<InstanceCount> instanceCounts() {
        return instanceCounts;
    }

    /**
     * <p>
     * The price of the Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The price of the Reserved Instance listing.
     */
    public List<PriceSchedule> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    /**
     * <p>
     * The status of the Reserved Instance listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Reserved Instance listing.
     * @see ListingStatus
     */
    public ListingStatus status() {
        return ListingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Reserved Instance listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Reserved Instance listing.
     * @see ListingStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the Reserved Instance listing. The response can be blank.
     * </p>
     * 
     * @return The reason for the current status of the Reserved Instance listing. The response can be blank.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The last modified timestamp of the listing.
     * </p>
     * 
     * @return The last modified timestamp of the listing.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListingId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(instanceCounts(), other.instanceCounts())
                && Objects.equals(priceSchedules(), other.priceSchedules())
                && Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(reservedInstancesListingId(), other.reservedInstancesListingId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(tags(), other.tags())
                && Objects.equals(updateDate(), other.updateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesListing").add("ClientToken", clientToken()).add("CreateDate", createDate())
                .add("InstanceCounts", instanceCounts()).add("PriceSchedules", priceSchedules())
                .add("ReservedInstancesId", reservedInstancesId())
                .add("ReservedInstancesListingId", reservedInstancesListingId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("Tags", tags()).add("UpdateDate", updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "InstanceCounts":
            return Optional.ofNullable(clazz.cast(instanceCounts()));
        case "PriceSchedules":
            return Optional.ofNullable(clazz.cast(priceSchedules()));
        case "ReservedInstancesId":
            return Optional.ofNullable(clazz.cast(reservedInstancesId()));
        case "ReservedInstancesListingId":
            return Optional.ofNullable(clazz.cast(reservedInstancesListingId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UpdateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesListing, T> g) {
        return obj -> g.apply((ReservedInstancesListing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstancesListing> {
        /**
         * <p>
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time the listing was created.
         * </p>
         * 
         * @param createDate
         *        The time the listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(Collection<InstanceCount> instanceCounts);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(InstanceCount... instanceCounts);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceCount>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceCount>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceCounts(List<InstanceCount>)}.
         * 
         * @param instanceCounts
         *        a consumer that will call methods on {@link List<InstanceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCounts(List<InstanceCount>)
         */
        Builder instanceCounts(Consumer<InstanceCount.Builder>... instanceCounts);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceSchedule> priceSchedules);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceSchedule... priceSchedules);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PriceSchedule>.Builder} avoiding the need
         * to create one manually via {@link List<PriceSchedule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PriceSchedule>.Builder#build()} is called immediately and
         * its result is passed to {@link #priceSchedules(List<PriceSchedule>)}.
         * 
         * @param priceSchedules
         *        a consumer that will call methods on {@link List<PriceSchedule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priceSchedules(List<PriceSchedule>)
         */
        Builder priceSchedules(Consumer<PriceSchedule.Builder>... priceSchedules);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(ListingStatus status);

        /**
         * <p>
         * The reason for the current status of the Reserved Instance listing. The response can be blank.
         * </p>
         * 
         * @param statusMessage
         *        The reason for the current status of the Reserved Instance listing. The response can be blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The last modified timestamp of the listing.
         * </p>
         * 
         * @param updateDate
         *        The last modified timestamp of the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant createDate;

        private List<InstanceCount> instanceCounts = DefaultSdkAutoConstructList.getInstance();

        private List<PriceSchedule> priceSchedules = DefaultSdkAutoConstructList.getInstance();

        private String reservedInstancesId;

        private String reservedInstancesListingId;

        private String status;

        private String statusMessage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            clientToken(model.clientToken);
            createDate(model.createDate);
            instanceCounts(model.instanceCounts);
            priceSchedules(model.priceSchedules);
            reservedInstancesId(model.reservedInstancesId);
            reservedInstancesListingId(model.reservedInstancesListingId);
            status(model.status);
            statusMessage(model.statusMessage);
            tags(model.tags);
            updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<InstanceCount.Builder> getInstanceCounts() {
            return instanceCounts != null ? instanceCounts.stream().map(InstanceCount::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount... instanceCounts) {
            instanceCounts(Arrays.asList(instanceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(Consumer<InstanceCount.Builder>... instanceCounts) {
            instanceCounts(Stream.of(instanceCounts).map(c -> InstanceCount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount.BuilderImpl> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copyFromBuilder(instanceCounts);
        }

        public final Collection<PriceSchedule.Builder> getPriceSchedules() {
            return priceSchedules != null ? priceSchedules.stream().map(PriceSchedule::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceSchedule.Builder>... priceSchedules) {
            priceSchedules(Stream.of(priceSchedules).map(c -> PriceSchedule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
