/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDhcpOptionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeDhcpOptionsResponse.Builder, DescribeDhcpOptionsResponse> {
    private static final SdkField<List<DhcpOptions>> DHCP_OPTIONS_FIELD = SdkField
            .<List<DhcpOptions>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDhcpOptionsResponse::dhcpOptions))
            .setter(setter(Builder::dhcpOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsSet")
                    .unmarshallLocationName("dhcpOptionsSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DhcpOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(DhcpOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDhcpOptionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_OPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DhcpOptions> dhcpOptions;

    private final String nextToken;

    private DescribeDhcpOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dhcpOptions = builder.dhcpOptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more DHCP options sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more DHCP options sets.
     */
    public List<DhcpOptions> dhcpOptions() {
        return dhcpOptions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsResponse)) {
            return false;
        }
        DescribeDhcpOptionsResponse other = (DescribeDhcpOptionsResponse) obj;
        return Objects.equals(dhcpOptions(), other.dhcpOptions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDhcpOptionsResponse").add("DhcpOptions", dhcpOptions()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpOptions":
            return Optional.ofNullable(clazz.cast(dhcpOptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDhcpOptionsResponse, T> g) {
        return obj -> g.apply((DescribeDhcpOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * 
         * @param dhcpOptions
         *        Information about one or more DHCP options sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptions(DhcpOptions... dhcpOptions);

        /**
         * <p>
         * Information about one or more DHCP options sets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DhcpOptions>.Builder} avoiding the need to
         * create one manually via {@link List<DhcpOptions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DhcpOptions>.Builder#build()} is called immediately and its
         * result is passed to {@link #dhcpOptions(List<DhcpOptions>)}.
         * 
         * @param dhcpOptions
         *        a consumer that will call methods on {@link List<DhcpOptions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpOptions(List<DhcpOptions>)
         */
        Builder dhcpOptions(Consumer<DhcpOptions.Builder>... dhcpOptions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DhcpOptions> dhcpOptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsResponse model) {
            super(model);
            dhcpOptions(model.dhcpOptions);
            nextToken(model.nextToken);
        }

        public final Collection<DhcpOptions.Builder> getDhcpOptions() {
            return dhcpOptions != null ? dhcpOptions.stream().map(DhcpOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(DhcpOptions... dhcpOptions) {
            dhcpOptions(Arrays.asList(dhcpOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(Consumer<DhcpOptions.Builder>... dhcpOptions) {
            dhcpOptions(Stream.of(dhcpOptions).map(c -> DhcpOptions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpOptions(Collection<DhcpOptions.BuilderImpl> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copyFromBuilder(dhcpOptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDhcpOptionsResponse build() {
            return new DescribeDhcpOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
