/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceEventStartTimeResponse extends Ec2Response implements
        ToCopyableBuilder<ModifyInstanceEventStartTimeResponse.Builder, ModifyInstanceEventStartTimeResponse> {
    private static final SdkField<InstanceStatusEvent> EVENT_FIELD = SdkField
            .<InstanceStatusEvent> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyInstanceEventStartTimeResponse::event))
            .setter(setter(Builder::event))
            .constructor(InstanceStatusEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event")
                    .unmarshallLocationName("event").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD));

    private final InstanceStatusEvent event;

    private ModifyInstanceEventStartTimeResponse(BuilderImpl builder) {
        super(builder);
        this.event = builder.event;
    }

    /**
     * Returns the value of the Event property for this object.
     * 
     * @return The value of the Event property for this object.
     */
    public InstanceStatusEvent event() {
        return event;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(event());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceEventStartTimeResponse)) {
            return false;
        }
        ModifyInstanceEventStartTimeResponse other = (ModifyInstanceEventStartTimeResponse) obj;
        return Objects.equals(event(), other.event());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyInstanceEventStartTimeResponse").add("Event", event()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceEventStartTimeResponse, T> g) {
        return obj -> g.apply((ModifyInstanceEventStartTimeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceEventStartTimeResponse> {
        /**
         * Sets the value of the Event property for this object.
         *
         * @param event
         *        The new value for the Event property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(InstanceStatusEvent event);

        /**
         * Sets the value of the Event property for this object.
         *
         * This is a convenience that creates an instance of the {@link InstanceStatusEvent.Builder} avoiding the need
         * to create one manually via {@link InstanceStatusEvent#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStatusEvent.Builder#build()} is called immediately and
         * its result is passed to {@link #event(InstanceStatusEvent)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link InstanceStatusEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(InstanceStatusEvent)
         */
        default Builder event(Consumer<InstanceStatusEvent.Builder> event) {
            return event(InstanceStatusEvent.builder().applyMutation(event).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceStatusEvent event;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceEventStartTimeResponse model) {
            super(model);
            event(model.event);
        }

        public final InstanceStatusEvent.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        @Override
        public final Builder event(InstanceStatusEvent event) {
            this.event = event;
            return this;
        }

        public final void setEvent(InstanceStatusEvent.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public ModifyInstanceEventStartTimeResponse build() {
            return new ModifyInstanceEventStartTimeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
