/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageRequest extends Ec2Request implements
        ToCopyableBuilder<CreateImageRequest.Builder, CreateImageRequest> {
    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(CreateImageRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("BlockDeviceMapping")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("BlockDeviceMapping")
                                                    .unmarshallLocationName("BlockDeviceMapping").build()).build()).build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<Boolean> NO_REBOOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateImageRequest::noReboot))
            .setter(setter(Builder::noReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoReboot")
                    .unmarshallLocationName("noReboot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DEVICE_MAPPINGS_FIELD,
            DESCRIPTION_FIELD, INSTANCE_ID_FIELD, NAME_FIELD, NO_REBOOT_FIELD));

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final String instanceId;

    private final String name;

    private final Boolean noReboot;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.noReboot = builder.noReboot;
    }

    /**
     * <p>
     * The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes or
     * snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The block device mappings. This parameter cannot be used to modify the encryption status of existing
     *         volumes or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * A description for the new image.
     * </p>
     * 
     * @return A description for the new image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A name for the new image.
     * </p>
     * <p>
     * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
     * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     * </p>
     * 
     * @return A name for the new image.</p>
     *         <p>
     *         Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods
     *         (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the 'No
     * Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option is
     * used, file system integrity on the created image can't be guaranteed.
     * </p>
     * 
     * @return By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the
     *         'No Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this
     *         option is used, file system integrity on the created image can't be guaranteed.
     */
    public Boolean noReboot() {
        return noReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(noReboot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest) obj;
        return Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(name(), other.name()) && Objects.equals(noReboot(), other.noReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateImageRequest").add("BlockDeviceMappings", blockDeviceMappings())
                .add("Description", description()).add("InstanceId", instanceId()).add("Name", name())
                .add("NoReboot", noReboot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NoReboot":
            return Optional.ofNullable(clazz.cast(noReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRequest, T> g) {
        return obj -> g.apply((CreateImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageRequest> {
        /**
         * <p>
         * The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes
         * or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings. This parameter cannot be used to modify the encryption status of existing
         *        volumes or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes
         * or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mappings. This parameter cannot be used to modify the encryption status of existing
         *        volumes or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mappings. This parameter cannot be used to modify the encryption status of existing volumes
         * or snapshots. To create an AMI with encrypted snapshots, use the <a>CopyImage</a> action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * A description for the new image.
         * </p>
         * 
         * @param description
         *        A description for the new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A name for the new image.
         * </p>
         * <p>
         * Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ), periods (.),
         * slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * </p>
         * 
         * @param name
         *        A name for the new image.</p>
         *        <p>
         *        Constraints: 3-128 alphanumeric characters, parentheses (()), square brackets ([]), spaces ( ),
         *        periods (.), slashes (/), dashes (-), single quotes ('), at-signs (@), or underscores(_)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the 'No
         * Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When this option
         * is used, file system integrity on the created image can't be guaranteed.
         * </p>
         * 
         * @param noReboot
         *        By default, Amazon EC2 attempts to shut down and reboot the instance before creating the image. If the
         *        'No Reboot' option is set, Amazon EC2 doesn't shut down the instance before creating the image. When
         *        this option is used, file system integrity on the created image can't be guaranteed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noReboot(Boolean noReboot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String instanceId;

        private String name;

        private Boolean noReboot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            super(model);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            instanceId(model.instanceId);
            name(model.name);
            noReboot(model.noReboot);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoReboot() {
            return noReboot;
        }

        @Override
        public final Builder noReboot(Boolean noReboot) {
            this.noReboot = noReboot;
            return this;
        }

        public final void setNoReboot(Boolean noReboot) {
            this.noReboot = noReboot;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
