/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon FPGA image (AFI) attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FpgaImageAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<FpgaImageAttribute.Builder, FpgaImageAttribute> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImageAttribute::fpgaImageId))
            .setter(setter(Builder::fpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("fpgaImageId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImageAttribute::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FpgaImageAttribute::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<LoadPermission>> LOAD_PERMISSIONS_FIELD = SdkField
            .<List<LoadPermission>> builder(MarshallingType.LIST)
            .getter(getter(FpgaImageAttribute::loadPermissions))
            .setter(setter(Builder::loadPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadPermissions")
                    .unmarshallLocationName("loadPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LoadPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(FpgaImageAttribute::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, LOAD_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fpgaImageId;

    private final String name;

    private final String description;

    private final List<LoadPermission> loadPermissions;

    private final List<ProductCode> productCodes;

    private FpgaImageAttribute(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.name = builder.name;
        this.description = builder.description;
        this.loadPermissions = builder.loadPermissions;
        this.productCodes = builder.productCodes;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The name of the AFI.
     * </p>
     * 
     * @return The name of the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AFI.
     * </p>
     * 
     * @return The description of the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The load permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The load permissions.
     */
    public List<LoadPermission> loadPermissions() {
        return loadPermissions;
    }

    /**
     * <p>
     * The product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loadPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImageAttribute)) {
            return false;
        }
        FpgaImageAttribute other = (FpgaImageAttribute) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(loadPermissions(), other.loadPermissions())
                && Objects.equals(productCodes(), other.productCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FpgaImageAttribute").add("FpgaImageId", fpgaImageId()).add("Name", name())
                .add("Description", description()).add("LoadPermissions", loadPermissions()).add("ProductCodes", productCodes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.ofNullable(clazz.cast(fpgaImageId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoadPermissions":
            return Optional.ofNullable(clazz.cast(loadPermissions()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaImageAttribute, T> g) {
        return obj -> g.apply((FpgaImageAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FpgaImageAttribute> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The name of the AFI.
         * </p>
         * 
         * @param name
         *        The name of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AFI.
         * </p>
         * 
         * @param description
         *        The description of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The load permissions.
         * </p>
         * 
         * @param loadPermissions
         *        The load permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermissions(Collection<LoadPermission> loadPermissions);

        /**
         * <p>
         * The load permissions.
         * </p>
         * 
         * @param loadPermissions
         *        The load permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermissions(LoadPermission... loadPermissions);

        /**
         * <p>
         * The load permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadPermission>.Builder} avoiding the need
         * to create one manually via {@link List<LoadPermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadPermission>.Builder#build()} is called immediately and
         * its result is passed to {@link #loadPermissions(List<LoadPermission>)}.
         * 
         * @param loadPermissions
         *        a consumer that will call methods on {@link List<LoadPermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadPermissions(List<LoadPermission>)
         */
        Builder loadPermissions(Consumer<LoadPermission.Builder>... loadPermissions);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * 
         * @param productCodes
         *        The product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The product codes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);
    }

    static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private String name;

        private String description;

        private List<LoadPermission> loadPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImageAttribute model) {
            fpgaImageId(model.fpgaImageId);
            name(model.name);
            description(model.description);
            loadPermissions(model.loadPermissions);
            productCodes(model.productCodes);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<LoadPermission.Builder> getLoadPermissions() {
            return loadPermissions != null ? loadPermissions.stream().map(LoadPermission::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadPermissions(Collection<LoadPermission> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copy(loadPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(LoadPermission... loadPermissions) {
            loadPermissions(Arrays.asList(loadPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadPermissions(Consumer<LoadPermission.Builder>... loadPermissions) {
            loadPermissions(Stream.of(loadPermissions).map(c -> LoadPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadPermissions(Collection<LoadPermission.BuilderImpl> loadPermissions) {
            this.loadPermissions = LoadPermissionListCopier.copyFromBuilder(loadPermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public FpgaImageAttribute build() {
            return new FpgaImageAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
