/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseHostReservationResponse extends Ec2Response implements
        ToCopyableBuilder<PurchaseHostReservationResponse.Builder, PurchaseHostReservationResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationResponse::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode")
                    .unmarshallLocationName("currencyCode").build()).build();

    private static final SdkField<List<Purchase>> PURCHASE_FIELD = SdkField
            .<List<Purchase>> builder(MarshallingType.LIST)
            .getter(getter(PurchaseHostReservationResponse::purchase))
            .setter(setter(Builder::purchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Purchase")
                    .unmarshallLocationName("purchase").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Purchase> builder(MarshallingType.SDK_POJO)
                                            .constructor(Purchase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> TOTAL_HOURLY_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationResponse::totalHourlyPrice))
            .setter(setter(Builder::totalHourlyPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalHourlyPrice")
                    .unmarshallLocationName("totalHourlyPrice").build()).build();

    private static final SdkField<String> TOTAL_UPFRONT_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PurchaseHostReservationResponse::totalUpfrontPrice))
            .setter(setter(Builder::totalUpfrontPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUpfrontPrice")
                    .unmarshallLocationName("totalUpfrontPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CURRENCY_CODE_FIELD, PURCHASE_FIELD, TOTAL_HOURLY_PRICE_FIELD, TOTAL_UPFRONT_PRICE_FIELD));

    private final String clientToken;

    private final String currencyCode;

    private final List<Purchase> purchase;

    private final String totalHourlyPrice;

    private final String totalUpfrontPrice;

    private PurchaseHostReservationResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * Describes the details of the purchase.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes the details of the purchase.
     */
    public List<Purchase> purchase() {
        return purchase;
    }

    /**
     * <p>
     * The total hourly price of the reservation calculated per hour.
     * </p>
     * 
     * @return The total hourly price of the reservation calculated per hour.
     */
    public String totalHourlyPrice() {
        return totalHourlyPrice;
    }

    /**
     * <p>
     * The total amount charged to your account when you purchase the reservation.
     * </p>
     * 
     * @return The total amount charged to your account when you purchase the reservation.
     */
    public String totalUpfrontPrice() {
        return totalUpfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(purchase());
        hashCode = 31 * hashCode + Objects.hashCode(totalHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(totalUpfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationResponse)) {
            return false;
        }
        PurchaseHostReservationResponse other = (PurchaseHostReservationResponse) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(purchase(), other.purchase()) && Objects.equals(totalHourlyPrice(), other.totalHourlyPrice())
                && Objects.equals(totalUpfrontPrice(), other.totalUpfrontPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PurchaseHostReservationResponse").add("ClientToken", clientToken())
                .add("CurrencyCode", currencyCodeAsString()).add("Purchase", purchase())
                .add("TotalHourlyPrice", totalHourlyPrice()).add("TotalUpfrontPrice", totalUpfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Purchase":
            return Optional.ofNullable(clazz.cast(purchase()));
        case "TotalHourlyPrice":
            return Optional.ofNullable(clazz.cast(totalHourlyPrice()));
        case "TotalUpfrontPrice":
            return Optional.ofNullable(clazz.cast(totalUpfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseHostReservationResponse, T> g) {
        return obj -> g.apply((PurchaseHostReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, PurchaseHostReservationResponse> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * Describes the details of the purchase.
         * </p>
         * 
         * @param purchase
         *        Describes the details of the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Collection<Purchase> purchase);

        /**
         * <p>
         * Describes the details of the purchase.
         * </p>
         * 
         * @param purchase
         *        Describes the details of the purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Purchase... purchase);

        /**
         * <p>
         * Describes the details of the purchase.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Purchase>.Builder} avoiding the need to
         * create one manually via {@link List<Purchase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Purchase>.Builder#build()} is called immediately and its
         * result is passed to {@link #purchase(List<Purchase>)}.
         * 
         * @param purchase
         *        a consumer that will call methods on {@link List<Purchase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #purchase(List<Purchase>)
         */
        Builder purchase(Consumer<Purchase.Builder>... purchase);

        /**
         * <p>
         * The total hourly price of the reservation calculated per hour.
         * </p>
         * 
         * @param totalHourlyPrice
         *        The total hourly price of the reservation calculated per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalHourlyPrice(String totalHourlyPrice);

        /**
         * <p>
         * The total amount charged to your account when you purchase the reservation.
         * </p>
         * 
         * @param totalUpfrontPrice
         *        The total amount charged to your account when you purchase the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUpfrontPrice(String totalUpfrontPrice);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String clientToken;

        private String currencyCode;

        private List<Purchase> purchase = DefaultSdkAutoConstructList.getInstance();

        private String totalHourlyPrice;

        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationResponse model) {
            super(model);
            clientToken(model.clientToken);
            currencyCode(model.currencyCode);
            purchase(model.purchase);
            totalHourlyPrice(model.totalHourlyPrice);
            totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCodeAsString() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return purchase != null ? purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase... purchase) {
            purchase(Arrays.asList(purchase));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Consumer<Purchase.Builder>... purchase) {
            purchase(Stream.of(purchase).map(c -> Purchase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public PurchaseHostReservationResponse build() {
            return new PurchaseHostReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
