/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes modifications to the list of create volume permissions for a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVolumePermissionModifications implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateVolumePermissionModifications.Builder, CreateVolumePermissionModifications> {
    private static final SdkField<List<CreateVolumePermission>> ADD_FIELD = SdkField
            .<List<CreateVolumePermission>> builder(MarshallingType.LIST)
            .getter(getter(CreateVolumePermissionModifications::add))
            .setter(setter(Builder::add))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Add").unmarshallLocationName("Add")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateVolumePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateVolumePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<CreateVolumePermission>> REMOVE_FIELD = SdkField
            .<List<CreateVolumePermission>> builder(MarshallingType.LIST)
            .getter(getter(CreateVolumePermissionModifications::remove))
            .setter(setter(Builder::remove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remove")
                    .unmarshallLocationName("Remove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CreateVolumePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateVolumePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_FIELD, REMOVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CreateVolumePermission> add;

    private final List<CreateVolumePermission> remove;

    private CreateVolumePermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    /**
     * <p>
     * Adds the specified AWS account ID or group to the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Adds the specified AWS account ID or group to the list.
     */
    public List<CreateVolumePermission> add() {
        return add;
    }

    /**
     * <p>
     * Removes the specified AWS account ID or group from the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Removes the specified AWS account ID or group from the list.
     */
    public List<CreateVolumePermission> remove() {
        return remove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(add());
        hashCode = 31 * hashCode + Objects.hashCode(remove());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumePermissionModifications)) {
            return false;
        }
        CreateVolumePermissionModifications other = (CreateVolumePermissionModifications) obj;
        return Objects.equals(add(), other.add()) && Objects.equals(remove(), other.remove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVolumePermissionModifications").add("Add", add()).add("Remove", remove()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Add":
            return Optional.ofNullable(clazz.cast(add()));
        case "Remove":
            return Optional.ofNullable(clazz.cast(remove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumePermissionModifications, T> g) {
        return obj -> g.apply((CreateVolumePermissionModifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateVolumePermissionModifications> {
        /**
         * <p>
         * Adds the specified AWS account ID or group to the list.
         * </p>
         * 
         * @param add
         *        Adds the specified AWS account ID or group to the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(Collection<CreateVolumePermission> add);

        /**
         * <p>
         * Adds the specified AWS account ID or group to the list.
         * </p>
         * 
         * @param add
         *        Adds the specified AWS account ID or group to the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder add(CreateVolumePermission... add);

        /**
         * <p>
         * Adds the specified AWS account ID or group to the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateVolumePermission>.Builder} avoiding
         * the need to create one manually via {@link List<CreateVolumePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateVolumePermission>.Builder#build()} is called
         * immediately and its result is passed to {@link #add(List<CreateVolumePermission>)}.
         * 
         * @param add
         *        a consumer that will call methods on {@link List<CreateVolumePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #add(List<CreateVolumePermission>)
         */
        Builder add(Consumer<CreateVolumePermission.Builder>... add);

        /**
         * <p>
         * Removes the specified AWS account ID or group from the list.
         * </p>
         * 
         * @param remove
         *        Removes the specified AWS account ID or group from the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(Collection<CreateVolumePermission> remove);

        /**
         * <p>
         * Removes the specified AWS account ID or group from the list.
         * </p>
         * 
         * @param remove
         *        Removes the specified AWS account ID or group from the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remove(CreateVolumePermission... remove);

        /**
         * <p>
         * Removes the specified AWS account ID or group from the list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateVolumePermission>.Builder} avoiding
         * the need to create one manually via {@link List<CreateVolumePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateVolumePermission>.Builder#build()} is called
         * immediately and its result is passed to {@link #remove(List<CreateVolumePermission>)}.
         * 
         * @param remove
         *        a consumer that will call methods on {@link List<CreateVolumePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remove(List<CreateVolumePermission>)
         */
        Builder remove(Consumer<CreateVolumePermission.Builder>... remove);
    }

    static final class BuilderImpl implements Builder {
        private List<CreateVolumePermission> add = DefaultSdkAutoConstructList.getInstance();

        private List<CreateVolumePermission> remove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumePermissionModifications model) {
            add(model.add);
            remove(model.remove);
        }

        public final Collection<CreateVolumePermission.Builder> getAdd() {
            return add != null ? add.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder add(Collection<CreateVolumePermission> add) {
            this.add = CreateVolumePermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(CreateVolumePermission... add) {
            add(Arrays.asList(add));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(Consumer<CreateVolumePermission.Builder>... add) {
            add(Stream.of(add).map(c -> CreateVolumePermission.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdd(Collection<CreateVolumePermission.BuilderImpl> add) {
            this.add = CreateVolumePermissionListCopier.copyFromBuilder(add);
        }

        public final Collection<CreateVolumePermission.Builder> getRemove() {
            return remove != null ? remove.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder remove(Collection<CreateVolumePermission> remove) {
            this.remove = CreateVolumePermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(CreateVolumePermission... remove) {
            remove(Arrays.asList(remove));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(Consumer<CreateVolumePermission.Builder>... remove) {
            remove(Stream.of(remove).map(c -> CreateVolumePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRemove(Collection<CreateVolumePermission.BuilderImpl> remove) {
            this.remove = CreateVolumePermissionListCopier.copyFromBuilder(remove);
        }

        @Override
        public CreateVolumePermissionModifications build() {
            return new CreateVolumePermissionModifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
