/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSecurityGroupReferencesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSecurityGroupReferencesResponse.Builder, DescribeSecurityGroupReferencesResponse> {
    private static final SdkField<List<SecurityGroupReference>> SECURITY_GROUP_REFERENCE_SET_FIELD = SdkField
            .<List<SecurityGroupReference>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSecurityGroupReferencesResponse::securityGroupReferenceSet))
            .setter(setter(Builder::securityGroupReferenceSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferenceSet")
                    .unmarshallLocationName("securityGroupReferenceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SecurityGroupReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityGroupReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SECURITY_GROUP_REFERENCE_SET_FIELD));

    private final List<SecurityGroupReference> securityGroupReferenceSet;

    private DescribeSecurityGroupReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupReferenceSet = builder.securityGroupReferenceSet;
    }

    /**
     * <p>
     * Information about the VPCs with the referencing security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the VPCs with the referencing security groups.
     */
    public List<SecurityGroupReference> securityGroupReferenceSet() {
        return securityGroupReferenceSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupReferenceSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesResponse)) {
            return false;
        }
        DescribeSecurityGroupReferencesResponse other = (DescribeSecurityGroupReferencesResponse) obj;
        return Objects.equals(securityGroupReferenceSet(), other.securityGroupReferenceSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSecurityGroupReferencesResponse")
                .add("SecurityGroupReferenceSet", securityGroupReferenceSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupReferenceSet":
            return Optional.ofNullable(clazz.cast(securityGroupReferenceSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupReferencesResponse, T> g) {
        return obj -> g.apply((DescribeSecurityGroupReferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
        /**
         * <p>
         * Information about the VPCs with the referencing security groups.
         * </p>
         * 
         * @param securityGroupReferenceSet
         *        Information about the VPCs with the referencing security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet);

        /**
         * <p>
         * Information about the VPCs with the referencing security groups.
         * </p>
         * 
         * @param securityGroupReferenceSet
         *        Information about the VPCs with the referencing security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupReferenceSet(SecurityGroupReference... securityGroupReferenceSet);

        /**
         * <p>
         * Information about the VPCs with the referencing security groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SecurityGroupReference>.Builder} avoiding
         * the need to create one manually via {@link List<SecurityGroupReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SecurityGroupReference>.Builder#build()} is called
         * immediately and its result is passed to {@link #securityGroupReferenceSet(List<SecurityGroupReference>)}.
         * 
         * @param securityGroupReferenceSet
         *        a consumer that will call methods on {@link List<SecurityGroupReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityGroupReferenceSet(List<SecurityGroupReference>)
         */
        Builder securityGroupReferenceSet(Consumer<SecurityGroupReference.Builder>... securityGroupReferenceSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SecurityGroupReference> securityGroupReferenceSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesResponse model) {
            super(model);
            securityGroupReferenceSet(model.securityGroupReferenceSet);
        }

        public final Collection<SecurityGroupReference.Builder> getSecurityGroupReferenceSet() {
            return securityGroupReferenceSet != null ? securityGroupReferenceSet.stream().map(SecurityGroupReference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copy(securityGroupReferenceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(SecurityGroupReference... securityGroupReferenceSet) {
            securityGroupReferenceSet(Arrays.asList(securityGroupReferenceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(Consumer<SecurityGroupReference.Builder>... securityGroupReferenceSet) {
            securityGroupReferenceSet(Stream.of(securityGroupReferenceSet)
                    .map(c -> SecurityGroupReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityGroupReferenceSet(Collection<SecurityGroupReference.BuilderImpl> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copyFromBuilder(securityGroupReferenceSet);
        }

        @Override
        public DescribeSecurityGroupReferencesResponse build() {
            return new DescribeSecurityGroupReferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
