/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyFpgaImageAttributeRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyFpgaImageAttributeRequest.Builder, ModifyFpgaImageAttributeRequest> {
    private static final SdkField<String> FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFpgaImageAttributeRequest::fpgaImageId))
            .setter(setter(Builder::fpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageId")
                    .unmarshallLocationName("FpgaImageId").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFpgaImageAttributeRequest::attributeAsString))
            .setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute")
                    .unmarshallLocationName("Attribute").build()).build();

    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFpgaImageAttributeRequest::operationTypeAsString))
            .setter(setter(Builder::operationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationType")
                    .unmarshallLocationName("OperationType").build()).build();

    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyFpgaImageAttributeRequest::userIds))
            .setter(setter(Builder::userIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId")
                    .unmarshallLocationName("UserId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserId").unmarshallLocationName("UserId").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyFpgaImageAttributeRequest::userGroups))
            .setter(setter(Builder::userGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup")
                    .unmarshallLocationName("UserGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UserGroup")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UserGroup").unmarshallLocationName("UserGroup").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> PRODUCT_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyFpgaImageAttributeRequest::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode")
                    .unmarshallLocationName("ProductCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ProductCode")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ProductCode").unmarshallLocationName("ProductCode").build())
                                            .build()).build()).build();

    private static final SdkField<LoadPermissionModifications> LOAD_PERMISSION_FIELD = SdkField
            .<LoadPermissionModifications> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyFpgaImageAttributeRequest::loadPermission))
            .setter(setter(Builder::loadPermission))
            .constructor(LoadPermissionModifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadPermission")
                    .unmarshallLocationName("LoadPermission").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFpgaImageAttributeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFpgaImageAttributeRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGE_ID_FIELD,
            ATTRIBUTE_FIELD, OPERATION_TYPE_FIELD, USER_IDS_FIELD, USER_GROUPS_FIELD, PRODUCT_CODES_FIELD, LOAD_PERMISSION_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD));

    private final String fpgaImageId;

    private final String attribute;

    private final String operationType;

    private final List<String> userIds;

    private final List<String> userGroups;

    private final List<String> productCodes;

    private final LoadPermissionModifications loadPermission;

    private final String description;

    private final String name;

    private ModifyFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
        this.operationType = builder.operationType;
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
        this.productCodes = builder.productCodes;
        this.loadPermission = builder.loadPermission;
        this.description = builder.description;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The name of the attribute.
     * @see FpgaImageAttributeName
     */
    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The name of the attribute.
     * @see FpgaImageAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The operation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeAsString}.
     * </p>
     * 
     * @return The operation type.
     * @see OperationType
     */
    public String operationTypeAsString() {
        return operationType;
    }

    /**
     * <p>
     * The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
     *         attribute.
     */
    public List<String> userIds() {
        return userIds;
    }

    /**
     * <p>
     * The user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
     */
    public List<String> userGroups() {
        return userGroups;
    }

    /**
     * <p>
     * The product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid only when
     * modifying the <code>productCodes</code> attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid
     *         only when modifying the <code>productCodes</code> attribute.
     */
    public List<String> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The load permission for the AFI.
     * </p>
     * 
     * @return The load permission for the AFI.
     */
    public LoadPermissionModifications loadPermission() {
        return loadPermission;
    }

    /**
     * <p>
     * A description for the AFI.
     * </p>
     * 
     * @return A description for the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A name for the AFI.
     * </p>
     * 
     * @return A name for the AFI.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userIds());
        hashCode = 31 * hashCode + Objects.hashCode(userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(loadPermission());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFpgaImageAttributeRequest)) {
            return false;
        }
        ModifyFpgaImageAttributeRequest other = (ModifyFpgaImageAttributeRequest) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId())
                && Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(operationTypeAsString(), other.operationTypeAsString())
                && Objects.equals(userIds(), other.userIds()) && Objects.equals(userGroups(), other.userGroups())
                && Objects.equals(productCodes(), other.productCodes())
                && Objects.equals(loadPermission(), other.loadPermission()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyFpgaImageAttributeRequest").add("FpgaImageId", fpgaImageId())
                .add("Attribute", attributeAsString()).add("OperationType", operationTypeAsString()).add("UserIds", userIds())
                .add("UserGroups", userGroups()).add("ProductCodes", productCodes()).add("LoadPermission", loadPermission())
                .add("Description", description()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.ofNullable(clazz.cast(fpgaImageId()));
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "OperationType":
            return Optional.ofNullable(clazz.cast(operationTypeAsString()));
        case "UserIds":
            return Optional.ofNullable(clazz.cast(userIds()));
        case "UserGroups":
            return Optional.ofNullable(clazz.cast(userGroups()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "LoadPermission":
            return Optional.ofNullable(clazz.cast(loadPermission()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFpgaImageAttributeRequest, T> g) {
        return obj -> g.apply((ModifyFpgaImageAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyFpgaImageAttributeRequest> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(FpgaImageAttributeName attribute);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The operation type.
         * </p>
         * 
         * @param operationType
         *        The operation type.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
         * </p>
         * 
         * @param userIds
         *        The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(Collection<String> userIds);

        /**
         * <p>
         * The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
         * </p>
         * 
         * @param userIds
         *        The AWS account IDs. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIds(String... userIds);

        /**
         * <p>
         * The user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(Collection<String> userGroups);

        /**
         * <p>
         * The user groups. This parameter is valid only when modifying the <code>loadPermission</code> attribute.
         * </p>
         * 
         * @param userGroups
         *        The user groups. This parameter is valid only when modifying the <code>loadPermission</code>
         *        attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroups(String... userGroups);

        /**
         * <p>
         * The product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid only
         * when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        The product codes. After you add a product code to an AFI, it can't be removed. This parameter is
         *        valid only when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<String> productCodes);

        /**
         * <p>
         * The product codes. After you add a product code to an AFI, it can't be removed. This parameter is valid only
         * when modifying the <code>productCodes</code> attribute.
         * </p>
         * 
         * @param productCodes
         *        The product codes. After you add a product code to an AFI, it can't be removed. This parameter is
         *        valid only when modifying the <code>productCodes</code> attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(String... productCodes);

        /**
         * <p>
         * The load permission for the AFI.
         * </p>
         * 
         * @param loadPermission
         *        The load permission for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadPermission(LoadPermissionModifications loadPermission);

        /**
         * <p>
         * The load permission for the AFI.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadPermissionModifications.Builder} avoiding
         * the need to create one manually via {@link LoadPermissionModifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadPermissionModifications.Builder#build()} is called
         * immediately and its result is passed to {@link #loadPermission(LoadPermissionModifications)}.
         * 
         * @param loadPermission
         *        a consumer that will call methods on {@link LoadPermissionModifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadPermission(LoadPermissionModifications)
         */
        default Builder loadPermission(Consumer<LoadPermissionModifications.Builder> loadPermission) {
            return loadPermission(LoadPermissionModifications.builder().applyMutation(loadPermission).build());
        }

        /**
         * <p>
         * A description for the AFI.
         * </p>
         * 
         * @param description
         *        A description for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the AFI.
         * </p>
         * 
         * @param name
         *        A name for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String attribute;

        private String operationType;

        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();

        private List<String> productCodes = DefaultSdkAutoConstructList.getInstance();

        private LoadPermissionModifications loadPermission;

        private String description;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFpgaImageAttributeRequest model) {
            super(model);
            fpgaImageId(model.fpgaImageId);
            attribute(model.attribute);
            operationType(model.operationType);
            userIds(model.userIds);
            userGroups(model.userGroups);
            productCodes(model.productCodes);
            loadPermission(model.loadPermission);
            description(model.description);
            name(model.name);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttributeAsString() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getOperationTypeAsString() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getUserIds() {
            return userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String... userIds) {
            userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final Collection<String> getUserGroups() {
            return userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String... userGroups) {
            userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final LoadPermissionModifications.Builder getLoadPermission() {
            return loadPermission != null ? loadPermission.toBuilder() : null;
        }

        @Override
        public final Builder loadPermission(LoadPermissionModifications loadPermission) {
            this.loadPermission = loadPermission;
            return this;
        }

        public final void setLoadPermission(LoadPermissionModifications.BuilderImpl loadPermission) {
            this.loadPermission = loadPermission != null ? loadPermission.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFpgaImageAttributeRequest build() {
            return new ModifyFpgaImageAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
