/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrafficMirrorFiltersResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeTrafficMirrorFiltersResponse.Builder, DescribeTrafficMirrorFiltersResponse> {
    private static final SdkField<List<TrafficMirrorFilter>> TRAFFIC_MIRROR_FILTERS_FIELD = SdkField
            .<List<TrafficMirrorFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrafficMirrorFiltersResponse::trafficMirrorFilters))
            .setter(setter(Builder::trafficMirrorFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterSet")
                    .unmarshallLocationName("trafficMirrorFilterSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TrafficMirrorFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficMirrorFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTrafficMirrorFiltersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TrafficMirrorFilter> trafficMirrorFilters;

    private final String nextToken;

    private DescribeTrafficMirrorFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilters = builder.trafficMirrorFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more Traffic Mirror filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more Traffic Mirror filters.
     */
    public List<TrafficMirrorFilter> trafficMirrorFilters() {
        return trafficMirrorFilters;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. The value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrafficMirrorFiltersResponse)) {
            return false;
        }
        DescribeTrafficMirrorFiltersResponse other = (DescribeTrafficMirrorFiltersResponse) obj;
        return Objects.equals(trafficMirrorFilters(), other.trafficMirrorFilters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrafficMirrorFiltersResponse").add("TrafficMirrorFilters", trafficMirrorFilters())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilters":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrafficMirrorFiltersResponse, T> g) {
        return obj -> g.apply((DescribeTrafficMirrorFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrafficMirrorFiltersResponse> {
        /**
         * <p>
         * Information about one or more Traffic Mirror filters.
         * </p>
         * 
         * @param trafficMirrorFilters
         *        Information about one or more Traffic Mirror filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilters(Collection<TrafficMirrorFilter> trafficMirrorFilters);

        /**
         * <p>
         * Information about one or more Traffic Mirror filters.
         * </p>
         * 
         * @param trafficMirrorFilters
         *        Information about one or more Traffic Mirror filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilters(TrafficMirrorFilter... trafficMirrorFilters);

        /**
         * <p>
         * Information about one or more Traffic Mirror filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrafficMirrorFilter>.Builder} avoiding the
         * need to create one manually via {@link List<TrafficMirrorFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrafficMirrorFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #trafficMirrorFilters(List<TrafficMirrorFilter>)}.
         * 
         * @param trafficMirrorFilters
         *        a consumer that will call methods on {@link List<TrafficMirrorFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorFilters(List<TrafficMirrorFilter>)
         */
        Builder trafficMirrorFilters(Consumer<TrafficMirrorFilter.Builder>... trafficMirrorFilters);

        /**
         * <p>
         * The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. The value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<TrafficMirrorFilter> trafficMirrorFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrafficMirrorFiltersResponse model) {
            super(model);
            trafficMirrorFilters(model.trafficMirrorFilters);
            nextToken(model.nextToken);
        }

        public final Collection<TrafficMirrorFilter.Builder> getTrafficMirrorFilters() {
            return trafficMirrorFilters != null ? trafficMirrorFilters.stream().map(TrafficMirrorFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficMirrorFilters(Collection<TrafficMirrorFilter> trafficMirrorFilters) {
            this.trafficMirrorFilters = TrafficMirrorFilterSetCopier.copy(trafficMirrorFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilters(TrafficMirrorFilter... trafficMirrorFilters) {
            trafficMirrorFilters(Arrays.asList(trafficMirrorFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficMirrorFilters(Consumer<TrafficMirrorFilter.Builder>... trafficMirrorFilters) {
            trafficMirrorFilters(Stream.of(trafficMirrorFilters).map(c -> TrafficMirrorFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficMirrorFilters(Collection<TrafficMirrorFilter.BuilderImpl> trafficMirrorFilters) {
            this.trafficMirrorFilters = TrafficMirrorFilterSetCopier.copyFromBuilder(trafficMirrorFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTrafficMirrorFiltersResponse build() {
            return new DescribeTrafficMirrorFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
