/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for a VPC attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTransitGatewayVpcAttachmentRequestOptions
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<ModifyTransitGatewayVpcAttachmentRequestOptions.Builder, ModifyTransitGatewayVpcAttachmentRequestOptions> {
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequestOptions::dnsSupportAsString))
            .setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport")
                    .unmarshallLocationName("DnsSupport").build()).build();

    private static final SdkField<String> IPV6_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyTransitGatewayVpcAttachmentRequestOptions::ipv6SupportAsString))
            .setter(setter(Builder::ipv6Support))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Support")
                    .unmarshallLocationName("Ipv6Support").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_SUPPORT_FIELD,
            IPV6_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dnsSupport;

    private final String ipv6Support;

    private ModifyTransitGatewayVpcAttachmentRequestOptions(BuilderImpl builder) {
        this.dnsSupport = builder.dnsSupport;
        this.ipv6Support = builder.ipv6Support;
    }

    /**
     * <p>
     * Enable or disable DNS support. The default is <code>enable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support. The default is <code>enable</code>.
     * @see DnsSupportValue
     */
    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(dnsSupport);
    }

    /**
     * <p>
     * Enable or disable DNS support. The default is <code>enable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Enable or disable DNS support. The default is <code>enable</code>.
     * @see DnsSupportValue
     */
    public String dnsSupportAsString() {
        return dnsSupport;
    }

    /**
     * <p>
     * Enable or disable IPv6 support. The default is <code>enable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipv6Support} will
     * return {@link Ipv6SupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipv6SupportAsString}.
     * </p>
     * 
     * @return Enable or disable IPv6 support. The default is <code>enable</code>.
     * @see Ipv6SupportValue
     */
    public Ipv6SupportValue ipv6Support() {
        return Ipv6SupportValue.fromValue(ipv6Support);
    }

    /**
     * <p>
     * Enable or disable IPv6 support. The default is <code>enable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipv6Support} will
     * return {@link Ipv6SupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipv6SupportAsString}.
     * </p>
     * 
     * @return Enable or disable IPv6 support. The default is <code>enable</code>.
     * @see Ipv6SupportValue
     */
    public String ipv6SupportAsString() {
        return ipv6Support;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6SupportAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayVpcAttachmentRequestOptions)) {
            return false;
        }
        ModifyTransitGatewayVpcAttachmentRequestOptions other = (ModifyTransitGatewayVpcAttachmentRequestOptions) obj;
        return Objects.equals(dnsSupportAsString(), other.dnsSupportAsString())
                && Objects.equals(ipv6SupportAsString(), other.ipv6SupportAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyTransitGatewayVpcAttachmentRequestOptions").add("DnsSupport", dnsSupportAsString())
                .add("Ipv6Support", ipv6SupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupportAsString()));
        case "Ipv6Support":
            return Optional.ofNullable(clazz.cast(ipv6SupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayVpcAttachmentRequestOptions, T> g) {
        return obj -> g.apply((ModifyTransitGatewayVpcAttachmentRequestOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequestOptions> {
        /**
         * <p>
         * Enable or disable DNS support. The default is <code>enable</code>.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support. The default is <code>enable</code>.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Enable or disable DNS support. The default is <code>enable</code>.
         * </p>
         * 
         * @param dnsSupport
         *        Enable or disable DNS support. The default is <code>enable</code>.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(DnsSupportValue dnsSupport);

        /**
         * <p>
         * Enable or disable IPv6 support. The default is <code>enable</code>.
         * </p>
         * 
         * @param ipv6Support
         *        Enable or disable IPv6 support. The default is <code>enable</code>.
         * @see Ipv6SupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ipv6SupportValue
         */
        Builder ipv6Support(String ipv6Support);

        /**
         * <p>
         * Enable or disable IPv6 support. The default is <code>enable</code>.
         * </p>
         * 
         * @param ipv6Support
         *        Enable or disable IPv6 support. The default is <code>enable</code>.
         * @see Ipv6SupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ipv6SupportValue
         */
        Builder ipv6Support(Ipv6SupportValue ipv6Support);
    }

    static final class BuilderImpl implements Builder {
        private String dnsSupport;

        private String ipv6Support;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayVpcAttachmentRequestOptions model) {
            dnsSupport(model.dnsSupport);
            ipv6Support(model.ipv6Support);
        }

        public final String getDnsSupportAsString() {
            return dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        public final String getIpv6SupportAsString() {
            return ipv6Support;
        }

        @Override
        public final Builder ipv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
            return this;
        }

        @Override
        public final Builder ipv6Support(Ipv6SupportValue ipv6Support) {
            this.ipv6Support(ipv6Support.toString());
            return this;
        }

        public final void setIpv6Support(String ipv6Support) {
            this.ipv6Support = ipv6Support;
        }

        @Override
        public ModifyTransitGatewayVpcAttachmentRequestOptions build() {
            return new ModifyTransitGatewayVpcAttachmentRequestOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
