/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClientVpnRouteResponse extends Ec2Response implements
        ToCopyableBuilder<CreateClientVpnRouteResponse.Builder, CreateClientVpnRouteResponse> {
    private static final SdkField<ClientVpnRouteStatus> STATUS_FIELD = SdkField
            .<ClientVpnRouteStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateClientVpnRouteResponse::status))
            .setter(setter(Builder::status))
            .constructor(ClientVpnRouteStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private final ClientVpnRouteStatus status;

    private CreateClientVpnRouteResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * <p>
     * The current state of the route.
     * </p>
     * 
     * @return The current state of the route.
     */
    public ClientVpnRouteStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnRouteResponse)) {
            return false;
        }
        CreateClientVpnRouteResponse other = (CreateClientVpnRouteResponse) obj;
        return Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClientVpnRouteResponse").add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnRouteResponse, T> g) {
        return obj -> g.apply((CreateClientVpnRouteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateClientVpnRouteResponse> {
        /**
         * <p>
         * The current state of the route.
         * </p>
         * 
         * @param status
         *        The current state of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ClientVpnRouteStatus status);

        /**
         * <p>
         * The current state of the route.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientVpnRouteStatus.Builder} avoiding the need
         * to create one manually via {@link ClientVpnRouteStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientVpnRouteStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(ClientVpnRouteStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ClientVpnRouteStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ClientVpnRouteStatus)
         */
        default Builder status(Consumer<ClientVpnRouteStatus.Builder> status) {
            return status(ClientVpnRouteStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ClientVpnRouteStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnRouteResponse model) {
            super(model);
            status(model.status);
        }

        public final ClientVpnRouteStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClientVpnRouteStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClientVpnRouteStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public CreateClientVpnRouteResponse build() {
            return new CreateClientVpnRouteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
