/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotInfo implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotInfo.Builder, SnapshotInfo> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(SnapshotInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SnapshotInfo::encrypted))
            .setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted")
                    .unmarshallLocationName("encrypted").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SnapshotInfo::volumeSize))
            .setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize")
                    .unmarshallLocationName("volumeSize").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SnapshotInfo::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::progress))
            .setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress")
                    .unmarshallLocationName("progress").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SnapshotInfo::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TAGS_FIELD,
            ENCRYPTED_FIELD, VOLUME_ID_FIELD, STATE_FIELD, VOLUME_SIZE_FIELD, START_TIME_FIELD, PROGRESS_FIELD, OWNER_ID_FIELD,
            SNAPSHOT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<Tag> tags;

    private final Boolean encrypted;

    private final String volumeId;

    private final String state;

    private final Integer volumeSize;

    private final Instant startTime;

    private final String progress;

    private final String ownerId;

    private final String snapshotId;

    private SnapshotInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.tags = builder.tags;
        this.encrypted = builder.encrypted;
        this.volumeId = builder.volumeId;
        this.state = builder.state;
        this.volumeSize = builder.volumeSize;
        this.startTime = builder.startTime;
        this.progress = builder.progress;
        this.ownerId = builder.ownerId;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * Description specified by the CreateSnapshotRequest that has been applied to all snapshots.
     * </p>
     * 
     * @return Description specified by the CreateSnapshotRequest that has been applied to all snapshots.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Tags associated with this snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tags associated with this snapshot.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether the snapshot is encrypted.
     * </p>
     * 
     * @return Indicates whether the snapshot is encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * Source volume from which this snapshot was created.
     * </p>
     * 
     * @return Source volume from which this snapshot was created.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Current state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the snapshot.
     * @see SnapshotState
     */
    public SnapshotState state() {
        return SnapshotState.fromValue(state);
    }

    /**
     * <p>
     * Current state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Current state of the snapshot.
     * @see SnapshotState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Size of the volume from which this snapshot was created.
     * </p>
     * 
     * @return Size of the volume from which this snapshot was created.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * Time this snapshot was started. This is the same for all snapshots initiated by the same request.
     * </p>
     * 
     * @return Time this snapshot was started. This is the same for all snapshots initiated by the same request.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Progress this snapshot has made towards completing.
     * </p>
     * 
     * @return Progress this snapshot has made towards completing.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * Account id used when creating this snapshot.
     * </p>
     * 
     * @return Account id used when creating this snapshot.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Snapshot id that can be used to describe this snapshot.
     * </p>
     * 
     * @return Snapshot id that can be used to describe this snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotInfo)) {
            return false;
        }
        SnapshotInfo other = (SnapshotInfo) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(progress(), other.progress())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SnapshotInfo").add("Description", description()).add("Tags", tags())
                .add("Encrypted", encrypted()).add("VolumeId", volumeId()).add("State", stateAsString())
                .add("VolumeSize", volumeSize()).add("StartTime", startTime()).add("Progress", progress())
                .add("OwnerId", ownerId()).add("SnapshotId", snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotInfo, T> g) {
        return obj -> g.apply((SnapshotInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotInfo> {
        /**
         * <p>
         * Description specified by the CreateSnapshotRequest that has been applied to all snapshots.
         * </p>
         * 
         * @param description
         *        Description specified by the CreateSnapshotRequest that has been applied to all snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags associated with this snapshot.
         * </p>
         * 
         * @param tags
         *        Tags associated with this snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags associated with this snapshot.
         * </p>
         * 
         * @param tags
         *        Tags associated with this snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags associated with this snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether the snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether the snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * Source volume from which this snapshot was created.
         * </p>
         * 
         * @param volumeId
         *        Source volume from which this snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Current state of the snapshot.
         * </p>
         * 
         * @param state
         *        Current state of the snapshot.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * Current state of the snapshot.
         * </p>
         * 
         * @param state
         *        Current state of the snapshot.
         * @see SnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotState
         */
        Builder state(SnapshotState state);

        /**
         * <p>
         * Size of the volume from which this snapshot was created.
         * </p>
         * 
         * @param volumeSize
         *        Size of the volume from which this snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * Time this snapshot was started. This is the same for all snapshots initiated by the same request.
         * </p>
         * 
         * @param startTime
         *        Time this snapshot was started. This is the same for all snapshots initiated by the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Progress this snapshot has made towards completing.
         * </p>
         * 
         * @param progress
         *        Progress this snapshot has made towards completing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * Account id used when creating this snapshot.
         * </p>
         * 
         * @param ownerId
         *        Account id used when creating this snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Snapshot id that can be used to describe this snapshot.
         * </p>
         * 
         * @param snapshotId
         *        Snapshot id that can be used to describe this snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean encrypted;

        private String volumeId;

        private String state;

        private Integer volumeSize;

        private Instant startTime;

        private String progress;

        private String ownerId;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotInfo model) {
            description(model.description);
            tags(model.tags);
            encrypted(model.encrypted);
            volumeId(model.volumeId);
            state(model.state);
            volumeSize(model.volumeSize);
            startTime(model.startTime);
            progress(model.progress);
            ownerId(model.ownerId);
            snapshotId(model.snapshotId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public SnapshotInfo build() {
            return new SnapshotInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
