/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotsResponse extends Ec2Response implements
        ToCopyableBuilder<CreateSnapshotsResponse.Builder, CreateSnapshotsResponse> {
    private static final SdkField<List<SnapshotInfo>> SNAPSHOTS_FIELD = SdkField
            .<List<SnapshotInfo>> builder(MarshallingType.LIST)
            .getter(getter(CreateSnapshotsResponse::snapshots))
            .setter(setter(Builder::snapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSet")
                    .unmarshallLocationName("snapshotSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SnapshotInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOTS_FIELD));

    private final List<SnapshotInfo> snapshots;

    private CreateSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
    }

    /**
     * <p>
     * List of snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of snapshots.
     */
    public List<SnapshotInfo> snapshots() {
        return snapshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshots());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotsResponse)) {
            return false;
        }
        CreateSnapshotsResponse other = (CreateSnapshotsResponse) obj;
        return Objects.equals(snapshots(), other.snapshots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSnapshotsResponse").add("Snapshots", snapshots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshots":
            return Optional.ofNullable(clazz.cast(snapshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotsResponse, T> g) {
        return obj -> g.apply((CreateSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotsResponse> {
        /**
         * <p>
         * List of snapshots.
         * </p>
         * 
         * @param snapshots
         *        List of snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<SnapshotInfo> snapshots);

        /**
         * <p>
         * List of snapshots.
         * </p>
         * 
         * @param snapshots
         *        List of snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(SnapshotInfo... snapshots);

        /**
         * <p>
         * List of snapshots.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SnapshotInfo>.Builder} avoiding the need to
         * create one manually via {@link List<SnapshotInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SnapshotInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshots(List<SnapshotInfo>)}.
         * 
         * @param snapshots
         *        a consumer that will call methods on {@link List<SnapshotInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshots(List<SnapshotInfo>)
         */
        Builder snapshots(Consumer<SnapshotInfo.Builder>... snapshots);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<SnapshotInfo> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotsResponse model) {
            super(model);
            snapshots(model.snapshots);
        }

        public final Collection<SnapshotInfo.Builder> getSnapshots() {
            return snapshots != null ? snapshots.stream().map(SnapshotInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<SnapshotInfo> snapshots) {
            this.snapshots = SnapshotSetCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(SnapshotInfo... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<SnapshotInfo.Builder>... snapshots) {
            snapshots(Stream.of(snapshots).map(c -> SnapshotInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshots(Collection<SnapshotInfo.BuilderImpl> snapshots) {
            this.snapshots = SnapshotSetCopier.copyFromBuilder(snapshots);
        }

        @Override
        public CreateSnapshotsResponse build() {
            return new CreateSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
