/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total value of the Convertible Reserved Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedInstanceReservationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedInstanceReservationValue.Builder, ReservedInstanceReservationValue> {
    private static final SdkField<ReservationValue> RESERVATION_VALUE_FIELD = SdkField
            .<ReservationValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReservedInstanceReservationValue::reservationValue))
            .setter(setter(Builder::reservationValue))
            .constructor(ReservationValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationValue")
                    .unmarshallLocationName("reservationValue").build()).build();

    private static final SdkField<String> RESERVED_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedInstanceReservationValue::reservedInstanceId))
            .setter(setter(Builder::reservedInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceId")
                    .unmarshallLocationName("reservedInstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_VALUE_FIELD,
            RESERVED_INSTANCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReservationValue reservationValue;

    private final String reservedInstanceId;

    private ReservedInstanceReservationValue(BuilderImpl builder) {
        this.reservationValue = builder.reservationValue;
        this.reservedInstanceId = builder.reservedInstanceId;
    }

    /**
     * <p>
     * The total value of the Convertible Reserved Instance that you are exchanging.
     * </p>
     * 
     * @return The total value of the Convertible Reserved Instance that you are exchanging.
     */
    public ReservationValue reservationValue() {
        return reservationValue;
    }

    /**
     * <p>
     * The ID of the Convertible Reserved Instance that you are exchanging.
     * </p>
     * 
     * @return The ID of the Convertible Reserved Instance that you are exchanging.
     */
    public String reservedInstanceId() {
        return reservedInstanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservationValue());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceReservationValue)) {
            return false;
        }
        ReservedInstanceReservationValue other = (ReservedInstanceReservationValue) obj;
        return Objects.equals(reservationValue(), other.reservationValue())
                && Objects.equals(reservedInstanceId(), other.reservedInstanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedInstanceReservationValue").add("ReservationValue", reservationValue())
                .add("ReservedInstanceId", reservedInstanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservationValue":
            return Optional.ofNullable(clazz.cast(reservationValue()));
        case "ReservedInstanceId":
            return Optional.ofNullable(clazz.cast(reservedInstanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstanceReservationValue, T> g) {
        return obj -> g.apply((ReservedInstanceReservationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedInstanceReservationValue> {
        /**
         * <p>
         * The total value of the Convertible Reserved Instance that you are exchanging.
         * </p>
         * 
         * @param reservationValue
         *        The total value of the Convertible Reserved Instance that you are exchanging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationValue(ReservationValue reservationValue);

        /**
         * <p>
         * The total value of the Convertible Reserved Instance that you are exchanging.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationValue.Builder} avoiding the need to
         * create one manually via {@link ReservationValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationValue.Builder#build()} is called immediately and its
         * result is passed to {@link #reservationValue(ReservationValue)}.
         * 
         * @param reservationValue
         *        a consumer that will call methods on {@link ReservationValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationValue(ReservationValue)
         */
        default Builder reservationValue(Consumer<ReservationValue.Builder> reservationValue) {
            return reservationValue(ReservationValue.builder().applyMutation(reservationValue).build());
        }

        /**
         * <p>
         * The ID of the Convertible Reserved Instance that you are exchanging.
         * </p>
         * 
         * @param reservedInstanceId
         *        The ID of the Convertible Reserved Instance that you are exchanging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstanceId(String reservedInstanceId);
    }

    static final class BuilderImpl implements Builder {
        private ReservationValue reservationValue;

        private String reservedInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceReservationValue model) {
            reservationValue(model.reservationValue);
            reservedInstanceId(model.reservedInstanceId);
        }

        public final ReservationValue.Builder getReservationValue() {
            return reservationValue != null ? reservationValue.toBuilder() : null;
        }

        @Override
        public final Builder reservationValue(ReservationValue reservationValue) {
            this.reservationValue = reservationValue;
            return this;
        }

        public final void setReservationValue(ReservationValue.BuilderImpl reservationValue) {
            this.reservationValue = reservationValue != null ? reservationValue.build() : null;
        }

        public final String getReservedInstanceId() {
            return reservedInstanceId;
        }

        @Override
        public final Builder reservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
            return this;
        }

        public final void setReservedInstanceId(String reservedInstanceId) {
            this.reservedInstanceId = reservedInstanceId;
        }

        @Override
        public ReservedInstanceReservationValue build() {
            return new ReservedInstanceReservationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
