/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrafficMirrorFilterRuleResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTrafficMirrorFilterRuleResponse.Builder, CreateTrafficMirrorFilterRuleResponse> {
    private static final SdkField<TrafficMirrorFilterRule> TRAFFIC_MIRROR_FILTER_RULE_FIELD = SdkField
            .<TrafficMirrorFilterRule> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTrafficMirrorFilterRuleResponse::trafficMirrorFilterRule))
            .setter(setter(Builder::trafficMirrorFilterRule))
            .constructor(TrafficMirrorFilterRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRule")
                    .unmarshallLocationName("trafficMirrorFilterRule").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrafficMirrorFilterRuleResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_RULE_FIELD, CLIENT_TOKEN_FIELD));

    private final TrafficMirrorFilterRule trafficMirrorFilterRule;

    private final String clientToken;

    private CreateTrafficMirrorFilterRuleResponse(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorFilterRule = builder.trafficMirrorFilterRule;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The Traffic Mirror rule.
     * </p>
     * 
     * @return The Traffic Mirror rule.
     */
    public TrafficMirrorFilterRule trafficMirrorFilterRule() {
        return trafficMirrorFilterRule;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterRule());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorFilterRuleResponse)) {
            return false;
        }
        CreateTrafficMirrorFilterRuleResponse other = (CreateTrafficMirrorFilterRuleResponse) obj;
        return Objects.equals(trafficMirrorFilterRule(), other.trafficMirrorFilterRule())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrafficMirrorFilterRuleResponse")
                .add("TrafficMirrorFilterRule", trafficMirrorFilterRule()).add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterRule":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterRule()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorFilterRuleResponse, T> g) {
        return obj -> g.apply((CreateTrafficMirrorFilterRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTrafficMirrorFilterRuleResponse> {
        /**
         * <p>
         * The Traffic Mirror rule.
         * </p>
         * 
         * @param trafficMirrorFilterRule
         *        The Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterRule(TrafficMirrorFilterRule trafficMirrorFilterRule);

        /**
         * <p>
         * The Traffic Mirror rule.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorFilterRule.Builder} avoiding the
         * need to create one manually via {@link TrafficMirrorFilterRule#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorFilterRule.Builder#build()} is called immediately
         * and its result is passed to {@link #trafficMirrorFilterRule(TrafficMirrorFilterRule)}.
         * 
         * @param trafficMirrorFilterRule
         *        a consumer that will call methods on {@link TrafficMirrorFilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficMirrorFilterRule(TrafficMirrorFilterRule)
         */
        default Builder trafficMirrorFilterRule(Consumer<TrafficMirrorFilterRule.Builder> trafficMirrorFilterRule) {
            return trafficMirrorFilterRule(TrafficMirrorFilterRule.builder().applyMutation(trafficMirrorFilterRule).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TrafficMirrorFilterRule trafficMirrorFilterRule;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorFilterRuleResponse model) {
            super(model);
            trafficMirrorFilterRule(model.trafficMirrorFilterRule);
            clientToken(model.clientToken);
        }

        public final TrafficMirrorFilterRule.Builder getTrafficMirrorFilterRule() {
            return trafficMirrorFilterRule != null ? trafficMirrorFilterRule.toBuilder() : null;
        }

        @Override
        public final Builder trafficMirrorFilterRule(TrafficMirrorFilterRule trafficMirrorFilterRule) {
            this.trafficMirrorFilterRule = trafficMirrorFilterRule;
            return this;
        }

        public final void setTrafficMirrorFilterRule(TrafficMirrorFilterRule.BuilderImpl trafficMirrorFilterRule) {
            this.trafficMirrorFilterRule = trafficMirrorFilterRule != null ? trafficMirrorFilterRule.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateTrafficMirrorFilterRuleResponse build() {
            return new CreateTrafficMirrorFilterRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
