/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCapacityReservationRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyCapacityReservationRequest.Builder, ModifyCapacityReservationRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyCapacityReservationRequest::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("CapacityReservationId").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyCapacityReservationRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ModifyCapacityReservationRequest::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("EndDate").build()).build();

    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyCapacityReservationRequest::endDateTypeAsString))
            .setter(setter(Builder::endDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType")
                    .unmarshallLocationName("EndDateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            INSTANCE_COUNT_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD));

    private final String capacityReservationId;

    private final Integer instanceCount;

    private final Instant endDate;

    private final String endDateType;

    private ModifyCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceCount = builder.instanceCount;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The number of instances for which to reserve capacity.
     * </p>
     * 
     * @return The number of instances for which to reserve capacity.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
     * capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * <code>expired</code> when it reaches its end date and time.
     * </p>
     * <p>
     * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     * </p>
     * <p>
     * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
     *         reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
     *         state changes to <code>expired</code> when it reaches its end date and time.</p>
     *         <p>
     *         The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
     *         5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
     *         5/31/2019.
     *         </p>
     *         <p>
     *         You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     *         <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     */
    public Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public EndDateType endDateType() {
        return EndDateType.fromValue(endDateType);
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public String endDateTypeAsString() {
        return endDateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationRequest)) {
            return false;
        }
        ModifyCapacityReservationRequest other = (ModifyCapacityReservationRequest) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(endDateTypeAsString(), other.endDateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyCapacityReservationRequest").add("CapacityReservationId", capacityReservationId())
                .add("InstanceCount", instanceCount()).add("EndDate", endDate()).add("EndDateType", endDateTypeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EndDateType":
            return Optional.ofNullable(clazz.cast(endDateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCapacityReservationRequest> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The number of instances for which to reserve capacity.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances for which to reserve capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         * reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
         * state changes to <code>expired</code> when it reaches its end date and time.
         * </p>
         * <p>
         * The Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify
         * 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
         * 5/31/2019.
         * </p>
         * <p>
         * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
         * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * 
         * @param endDate
         *        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         *        reserved capacity is released and you can no longer launch instances into it. The Capacity
         *        Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
         *        <p>
         *        The Capacity Reservation is cancelled within an hour from the specified time. For example, if you
         *        specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and
         *        14:30:55 on 5/31/2019.
         *        </p>
         *        <p>
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(String endDateType);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(EndDateType endDateType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String capacityReservationId;

        private Integer instanceCount;

        private Instant endDate;

        private String endDateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationRequest model) {
            super(model);
            capacityReservationId(model.capacityReservationId);
            instanceCount(model.instanceCount);
            endDate(model.endDate);
            endDateType(model.endDateType);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final String getEndDateTypeAsString() {
            return endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationRequest build() {
            return new ModifyCapacityReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
