/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcAttributeResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeVpcAttributeResponse.Builder, DescribeVpcAttributeResponse> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeVpcAttributeResponse::vpcId))
            .setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId")
                    .unmarshallLocationName("vpcId").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_HOSTNAMES_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeVpcAttributeResponse::enableDnsHostnames))
            .setter(setter(Builder::enableDnsHostnames))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsHostnames")
                    .unmarshallLocationName("enableDnsHostnames").build()).build();

    private static final SdkField<AttributeBooleanValue> ENABLE_DNS_SUPPORT_FIELD = SdkField
            .<AttributeBooleanValue> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeVpcAttributeResponse::enableDnsSupport))
            .setter(setter(Builder::enableDnsSupport))
            .constructor(AttributeBooleanValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDnsSupport")
                    .unmarshallLocationName("enableDnsSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            ENABLE_DNS_HOSTNAMES_FIELD, ENABLE_DNS_SUPPORT_FIELD));

    private final String vpcId;

    private final AttributeBooleanValue enableDnsHostnames;

    private final AttributeBooleanValue enableDnsSupport;

    private DescribeVpcAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>,
     * instances in the VPC get DNS hostnames; otherwise, they do not.
     * </p>
     * 
     * @return Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is
     *         <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.
     */
    public AttributeBooleanValue enableDnsHostnames() {
        return enableDnsHostnames;
    }

    /**
     * <p>
     * Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon DNS
     * server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does not.
     * </p>
     * 
     * @return Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the
     *         Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses;
     *         otherwise, it does not.
     */
    public AttributeBooleanValue enableDnsSupport() {
        return enableDnsSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsSupport());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcAttributeResponse)) {
            return false;
        }
        DescribeVpcAttributeResponse other = (DescribeVpcAttributeResponse) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(enableDnsHostnames(), other.enableDnsHostnames())
                && Objects.equals(enableDnsSupport(), other.enableDnsSupport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVpcAttributeResponse").add("VpcId", vpcId())
                .add("EnableDnsHostnames", enableDnsHostnames()).add("EnableDnsSupport", enableDnsSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "EnableDnsHostnames":
            return Optional.ofNullable(clazz.cast(enableDnsHostnames()));
        case "EnableDnsSupport":
            return Optional.ofNullable(clazz.cast(enableDnsSupport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcAttributeResponse, T> g) {
        return obj -> g.apply((DescribeVpcAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcAttributeResponse> {
        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>
         * , instances in the VPC get DNS hostnames; otherwise, they do not.
         * </p>
         * 
         * @param enableDnsHostnames
         *        Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is
         *        <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsHostnames(AttributeBooleanValue enableDnsHostnames);

        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>
         * , instances in the VPC get DNS hostnames; otherwise, they do not.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding the need
         * to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableDnsHostnames(AttributeBooleanValue)}.
         * 
         * @param enableDnsHostnames
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableDnsHostnames(AttributeBooleanValue)
         */
        default Builder enableDnsHostnames(Consumer<AttributeBooleanValue.Builder> enableDnsHostnames) {
            return enableDnsHostnames(AttributeBooleanValue.builder().applyMutation(enableDnsHostnames).build());
        }

        /**
         * <p>
         * Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon
         * DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does
         * not.
         * </p>
         * 
         * @param enableDnsSupport
         *        Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the
         *        Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses;
         *        otherwise, it does not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsSupport(AttributeBooleanValue enableDnsSupport);

        /**
         * <p>
         * Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon
         * DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does
         * not.
         * </p>
         * This is a convenience that creates an instance of the {@link AttributeBooleanValue.Builder} avoiding the need
         * to create one manually via {@link AttributeBooleanValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttributeBooleanValue.Builder#build()} is called immediately and
         * its result is passed to {@link #enableDnsSupport(AttributeBooleanValue)}.
         * 
         * @param enableDnsSupport
         *        a consumer that will call methods on {@link AttributeBooleanValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableDnsSupport(AttributeBooleanValue)
         */
        default Builder enableDnsSupport(Consumer<AttributeBooleanValue.Builder> enableDnsSupport) {
            return enableDnsSupport(AttributeBooleanValue.builder().applyMutation(enableDnsSupport).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String vpcId;

        private AttributeBooleanValue enableDnsHostnames;

        private AttributeBooleanValue enableDnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcAttributeResponse model) {
            super(model);
            vpcId(model.vpcId);
            enableDnsHostnames(model.enableDnsHostnames);
            enableDnsSupport(model.enableDnsSupport);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final AttributeBooleanValue.Builder getEnableDnsHostnames() {
            return enableDnsHostnames != null ? enableDnsHostnames.toBuilder() : null;
        }

        @Override
        public final Builder enableDnsHostnames(AttributeBooleanValue enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(AttributeBooleanValue.BuilderImpl enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames != null ? enableDnsHostnames.build() : null;
        }

        public final AttributeBooleanValue.Builder getEnableDnsSupport() {
            return enableDnsSupport != null ? enableDnsSupport.toBuilder() : null;
        }

        @Override
        public final Builder enableDnsSupport(AttributeBooleanValue enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(AttributeBooleanValue.BuilderImpl enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport != null ? enableDnsSupport.build() : null;
        }

        @Override
        public DescribeVpcAttributeResponse build() {
            return new DescribeVpcAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
