/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFlowLogsRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteFlowLogsRequest.Builder, DeleteFlowLogsRequest> {
    private static final SdkField<List<String>> FLOW_LOG_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteFlowLogsRequest::flowLogIds))
            .setter(setter(Builder::flowLogIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId")
                    .unmarshallLocationName("FlowLogId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_LOG_IDS_FIELD));

    private final List<String> flowLogIds;

    private DeleteFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.flowLogIds = builder.flowLogIds;
    }

    /**
     * <p>
     * One or more flow log IDs.
     * </p>
     * <p>
     * Constraint: Maximum of 1000 flow log IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more flow log IDs.</p>
     *         <p>
     *         Constraint: Maximum of 1000 flow log IDs.
     */
    public List<String> flowLogIds() {
        return flowLogIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowLogIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsRequest)) {
            return false;
        }
        DeleteFlowLogsRequest other = (DeleteFlowLogsRequest) obj;
        return Objects.equals(flowLogIds(), other.flowLogIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteFlowLogsRequest").add("FlowLogIds", flowLogIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowLogIds":
            return Optional.ofNullable(clazz.cast(flowLogIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowLogsRequest, T> g) {
        return obj -> g.apply((DeleteFlowLogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteFlowLogsRequest> {
        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * <p>
         * Constraint: Maximum of 1000 flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.</p>
         *        <p>
         *        Constraint: Maximum of 1000 flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(Collection<String> flowLogIds);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * <p>
         * Constraint: Maximum of 1000 flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.</p>
         *        <p>
         *        Constraint: Maximum of 1000 flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(String... flowLogIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> flowLogIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsRequest model) {
            super(model);
            flowLogIds(model.flowLogIds);
        }

        public final Collection<String> getFlowLogIds() {
            return flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String... flowLogIds) {
            flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowLogsRequest build() {
            return new DeleteFlowLogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
