/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Traffic Mirror rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficMirrorFilterRule implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficMirrorFilterRule.Builder, TrafficMirrorFilterRule> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::trafficMirrorFilterRuleId))
            .setter(setter(Builder::trafficMirrorFilterRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterRuleId")
                    .unmarshallLocationName("trafficMirrorFilterRuleId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("trafficMirrorFilterId").build()).build();

    private static final SdkField<String> TRAFFIC_DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::trafficDirectionAsString))
            .setter(setter(Builder::trafficDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDirection")
                    .unmarshallLocationName("trafficDirection").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficMirrorFilterRule::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final SdkField<String> RULE_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::ruleActionAsString))
            .setter(setter(Builder::ruleAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction")
                    .unmarshallLocationName("ruleAction").build()).build();

    private static final SdkField<Integer> PROTOCOL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TrafficMirrorFilterRule::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<TrafficMirrorPortRange> DESTINATION_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrafficMirrorFilterRule::destinationPortRange))
            .setter(setter(Builder::destinationPortRange))
            .constructor(TrafficMirrorPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRange")
                    .unmarshallLocationName("destinationPortRange").build()).build();

    private static final SdkField<TrafficMirrorPortRange> SOURCE_PORT_RANGE_FIELD = SdkField
            .<TrafficMirrorPortRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrafficMirrorFilterRule::sourcePortRange))
            .setter(setter(Builder::sourcePortRange))
            .constructor(TrafficMirrorPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRange")
                    .unmarshallLocationName("sourcePortRange").build()).build();

    private static final SdkField<String> DESTINATION_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::destinationCidrBlock))
            .setter(setter(Builder::destinationCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationCidrBlock")
                    .unmarshallLocationName("destinationCidrBlock").build()).build();

    private static final SdkField<String> SOURCE_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::sourceCidrBlock))
            .setter(setter(Builder::sourceCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCidrBlock")
                    .unmarshallLocationName("sourceCidrBlock").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorFilterRule::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_RULE_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, TRAFFIC_DIRECTION_FIELD, RULE_NUMBER_FIELD,
            RULE_ACTION_FIELD, PROTOCOL_FIELD, DESTINATION_PORT_RANGE_FIELD, SOURCE_PORT_RANGE_FIELD,
            DESTINATION_CIDR_BLOCK_FIELD, SOURCE_CIDR_BLOCK_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trafficMirrorFilterRuleId;

    private final String trafficMirrorFilterId;

    private final String trafficDirection;

    private final Integer ruleNumber;

    private final String ruleAction;

    private final Integer protocol;

    private final TrafficMirrorPortRange destinationPortRange;

    private final TrafficMirrorPortRange sourcePortRange;

    private final String destinationCidrBlock;

    private final String sourceCidrBlock;

    private final String description;

    private TrafficMirrorFilterRule(BuilderImpl builder) {
        this.trafficMirrorFilterRuleId = builder.trafficMirrorFilterRuleId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.trafficDirection = builder.trafficDirection;
        this.ruleNumber = builder.ruleNumber;
        this.ruleAction = builder.ruleAction;
        this.protocol = builder.protocol;
        this.destinationPortRange = builder.destinationPortRange;
        this.sourcePortRange = builder.sourcePortRange;
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.sourceCidrBlock = builder.sourceCidrBlock;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror rule.
     * </p>
     * 
     * @return The ID of the Traffic Mirror rule.
     */
    public String trafficMirrorFilterRuleId() {
        return trafficMirrorFilterRuleId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter that the rule is associated with.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter that the rule is associated with.
     */
    public String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The traffic direction assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The traffic direction assigned to the Traffic Mirror rule.
     * @see TrafficDirection
     */
    public TrafficDirection trafficDirection() {
        return TrafficDirection.fromValue(trafficDirection);
    }

    /**
     * <p>
     * The traffic direction assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficDirection}
     * will return {@link TrafficDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trafficDirectionAsString}.
     * </p>
     * 
     * @return The traffic direction assigned to the Traffic Mirror rule.
     * @see TrafficDirection
     */
    public String trafficDirectionAsString() {
        return trafficDirection;
    }

    /**
     * <p>
     * The rule number of the Traffic Mirror rule.
     * </p>
     * 
     * @return The rule number of the Traffic Mirror rule.
     */
    public Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * The action assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action assigned to the Traffic Mirror rule.
     * @see TrafficMirrorRuleAction
     */
    public TrafficMirrorRuleAction ruleAction() {
        return TrafficMirrorRuleAction.fromValue(ruleAction);
    }

    /**
     * <p>
     * The action assigned to the Traffic Mirror rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleAction} will
     * return {@link TrafficMirrorRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleActionAsString}.
     * </p>
     * 
     * @return The action assigned to the Traffic Mirror rule.
     * @see TrafficMirrorRuleAction
     */
    public String ruleActionAsString() {
        return ruleAction;
    }

    /**
     * <p>
     * The protocol assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The protocol assigned to the Traffic Mirror rule.
     */
    public Integer protocol() {
        return protocol;
    }

    /**
     * <p>
     * The destination port range assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination port range assigned to the Traffic Mirror rule.
     */
    public TrafficMirrorPortRange destinationPortRange() {
        return destinationPortRange;
    }

    /**
     * <p>
     * The source port range assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source port range assigned to the Traffic Mirror rule.
     */
    public TrafficMirrorPortRange sourcePortRange() {
        return sourcePortRange;
    }

    /**
     * <p>
     * The destination CIDR block assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The destination CIDR block assigned to the Traffic Mirror rule.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The source CIDR block assigned to the Traffic Mirror rule.
     * </p>
     * 
     * @return The source CIDR block assigned to the Traffic Mirror rule.
     */
    public String sourceCidrBlock() {
        return sourceCidrBlock;
    }

    /**
     * <p>
     * The description of the Traffic Mirror rule.
     * </p>
     * 
     * @return The description of the Traffic Mirror rule.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(ruleActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePortRange());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilterRule)) {
            return false;
        }
        TrafficMirrorFilterRule other = (TrafficMirrorFilterRule) obj;
        return Objects.equals(trafficMirrorFilterRuleId(), other.trafficMirrorFilterRuleId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(trafficDirectionAsString(), other.trafficDirectionAsString())
                && Objects.equals(ruleNumber(), other.ruleNumber())
                && Objects.equals(ruleActionAsString(), other.ruleActionAsString())
                && Objects.equals(protocol(), other.protocol())
                && Objects.equals(destinationPortRange(), other.destinationPortRange())
                && Objects.equals(sourcePortRange(), other.sourcePortRange())
                && Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(sourceCidrBlock(), other.sourceCidrBlock())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrafficMirrorFilterRule").add("TrafficMirrorFilterRuleId", trafficMirrorFilterRuleId())
                .add("TrafficMirrorFilterId", trafficMirrorFilterId()).add("TrafficDirection", trafficDirectionAsString())
                .add("RuleNumber", ruleNumber()).add("RuleAction", ruleActionAsString()).add("Protocol", protocol())
                .add("DestinationPortRange", destinationPortRange()).add("SourcePortRange", sourcePortRange())
                .add("DestinationCidrBlock", destinationCidrBlock()).add("SourceCidrBlock", sourceCidrBlock())
                .add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterRuleId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterRuleId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "TrafficDirection":
            return Optional.ofNullable(clazz.cast(trafficDirectionAsString()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "RuleAction":
            return Optional.ofNullable(clazz.cast(ruleActionAsString()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "DestinationPortRange":
            return Optional.ofNullable(clazz.cast(destinationPortRange()));
        case "SourcePortRange":
            return Optional.ofNullable(clazz.cast(sourcePortRange()));
        case "DestinationCidrBlock":
            return Optional.ofNullable(clazz.cast(destinationCidrBlock()));
        case "SourceCidrBlock":
            return Optional.ofNullable(clazz.cast(sourceCidrBlock()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorFilterRule, T> g) {
        return obj -> g.apply((TrafficMirrorFilterRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficMirrorFilterRule> {
        /**
         * <p>
         * The ID of the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficMirrorFilterRuleId
         *        The ID of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter that the rule is associated with.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter that the rule is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The traffic direction assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficDirection
         *        The traffic direction assigned to the Traffic Mirror rule.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(String trafficDirection);

        /**
         * <p>
         * The traffic direction assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param trafficDirection
         *        The traffic direction assigned to the Traffic Mirror rule.
         * @see TrafficDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDirection
         */
        Builder trafficDirection(TrafficDirection trafficDirection);

        /**
         * <p>
         * The rule number of the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * The action assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleAction
         *        The action assigned to the Traffic Mirror rule.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(String ruleAction);

        /**
         * <p>
         * The action assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param ruleAction
         *        The action assigned to the Traffic Mirror rule.
         * @see TrafficMirrorRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorRuleAction
         */
        Builder ruleAction(TrafficMirrorRuleAction ruleAction);

        /**
         * <p>
         * The protocol assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param protocol
         *        The protocol assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(Integer protocol);

        /**
         * <p>
         * The destination port range assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationPortRange
         *        The destination port range assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRange(TrafficMirrorPortRange destinationPortRange);

        /**
         * <p>
         * The destination port range assigned to the Traffic Mirror rule.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorPortRange.Builder} avoiding the
         * need to create one manually via {@link TrafficMirrorPortRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationPortRange(TrafficMirrorPortRange)}.
         * 
         * @param destinationPortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRange(TrafficMirrorPortRange)
         */
        default Builder destinationPortRange(Consumer<TrafficMirrorPortRange.Builder> destinationPortRange) {
            return destinationPortRange(TrafficMirrorPortRange.builder().applyMutation(destinationPortRange).build());
        }

        /**
         * <p>
         * The source port range assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourcePortRange
         *        The source port range assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRange(TrafficMirrorPortRange sourcePortRange);

        /**
         * <p>
         * The source port range assigned to the Traffic Mirror rule.
         * </p>
         * This is a convenience that creates an instance of the {@link TrafficMirrorPortRange.Builder} avoiding the
         * need to create one manually via {@link TrafficMirrorPortRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrafficMirrorPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sourcePortRange(TrafficMirrorPortRange)}.
         * 
         * @param sourcePortRange
         *        a consumer that will call methods on {@link TrafficMirrorPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRange(TrafficMirrorPortRange)
         */
        default Builder sourcePortRange(Consumer<TrafficMirrorPortRange.Builder> sourcePortRange) {
            return sourcePortRange(TrafficMirrorPortRange.builder().applyMutation(sourcePortRange).build());
        }

        /**
         * <p>
         * The destination CIDR block assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The destination CIDR block assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The source CIDR block assigned to the Traffic Mirror rule.
         * </p>
         * 
         * @param sourceCidrBlock
         *        The source CIDR block assigned to the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCidrBlock(String sourceCidrBlock);

        /**
         * <p>
         * The description of the Traffic Mirror rule.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String trafficMirrorFilterRuleId;

        private String trafficMirrorFilterId;

        private String trafficDirection;

        private Integer ruleNumber;

        private String ruleAction;

        private Integer protocol;

        private TrafficMirrorPortRange destinationPortRange;

        private TrafficMirrorPortRange sourcePortRange;

        private String destinationCidrBlock;

        private String sourceCidrBlock;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorFilterRule model) {
            trafficMirrorFilterRuleId(model.trafficMirrorFilterRuleId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            trafficDirection(model.trafficDirection);
            ruleNumber(model.ruleNumber);
            ruleAction(model.ruleAction);
            protocol(model.protocol);
            destinationPortRange(model.destinationPortRange);
            sourcePortRange(model.sourcePortRange);
            destinationCidrBlock(model.destinationCidrBlock);
            sourceCidrBlock(model.sourceCidrBlock);
            description(model.description);
        }

        public final String getTrafficMirrorFilterRuleId() {
            return trafficMirrorFilterRuleId;
        }

        @Override
        public final Builder trafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
            return this;
        }

        public final void setTrafficMirrorFilterRuleId(String trafficMirrorFilterRuleId) {
            this.trafficMirrorFilterRuleId = trafficMirrorFilterRuleId;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final String getTrafficDirectionAsString() {
            return trafficDirection;
        }

        @Override
        public final Builder trafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
            return this;
        }

        @Override
        public final Builder trafficDirection(TrafficDirection trafficDirection) {
            this.trafficDirection(trafficDirection.toString());
            return this;
        }

        public final void setTrafficDirection(String trafficDirection) {
            this.trafficDirection = trafficDirection;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public final String getRuleActionAsString() {
            return ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(TrafficMirrorRuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(Integer protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(Integer protocol) {
            this.protocol = protocol;
        }

        public final TrafficMirrorPortRange.Builder getDestinationPortRange() {
            return destinationPortRange != null ? destinationPortRange.toBuilder() : null;
        }

        @Override
        public final Builder destinationPortRange(TrafficMirrorPortRange destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        public final void setDestinationPortRange(TrafficMirrorPortRange.BuilderImpl destinationPortRange) {
            this.destinationPortRange = destinationPortRange != null ? destinationPortRange.build() : null;
        }

        public final TrafficMirrorPortRange.Builder getSourcePortRange() {
            return sourcePortRange != null ? sourcePortRange.toBuilder() : null;
        }

        @Override
        public final Builder sourcePortRange(TrafficMirrorPortRange sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        public final void setSourcePortRange(TrafficMirrorPortRange.BuilderImpl sourcePortRange) {
            this.sourcePortRange = sourcePortRange != null ? sourcePortRange.build() : null;
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getSourceCidrBlock() {
            return sourceCidrBlock;
        }

        @Override
        public final Builder sourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        public final void setSourceCidrBlock(String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public TrafficMirrorFilterRule build() {
            return new TrafficMirrorFilterRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
