/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Traffic Mirror target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficMirrorTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficMirrorTarget.Builder, TrafficMirrorTarget> {
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("trafficMirrorTargetId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> NETWORK_LOAD_BALANCER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::networkLoadBalancerArn))
            .setter(setter(Builder::networkLoadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn")
                    .unmarshallLocationName("networkLoadBalancerArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TrafficMirrorTarget::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(TrafficMirrorTarget::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_TARGET_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_LOAD_BALANCER_ARN_FIELD, TYPE_FIELD,
            DESCRIPTION_FIELD, OWNER_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trafficMirrorTargetId;

    private final String networkInterfaceId;

    private final String networkLoadBalancerArn;

    private final String type;

    private final String description;

    private final String ownerId;

    private final List<Tag> tags;

    private TrafficMirrorTarget(BuilderImpl builder) {
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkLoadBalancerArn = builder.networkLoadBalancerArn;
        this.type = builder.type;
        this.description = builder.description;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror target.
     * </p>
     * 
     * @return The ID of the Traffic Mirror target.
     */
    public String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    /**
     * <p>
     * The network interface ID that is attached to the target.
     * </p>
     * 
     * @return The network interface ID that is attached to the target.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Network Load Balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Network Load Balancer.
     */
    public String networkLoadBalancerArn() {
        return networkLoadBalancerArn;
    }

    /**
     * <p>
     * The type of Traffic Mirror target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TrafficMirrorTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Traffic Mirror target.
     * @see TrafficMirrorTargetType
     */
    public TrafficMirrorTargetType type() {
        return TrafficMirrorTargetType.fromValue(type);
    }

    /**
     * <p>
     * The type of Traffic Mirror target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TrafficMirrorTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Traffic Mirror target.
     * @see TrafficMirrorTargetType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Information about the Traffic Mirror target.
     * </p>
     * 
     * @return Information about the Traffic Mirror target.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the account that owns the Traffic Mirror target.
     * </p>
     * 
     * @return The ID of the account that owns the Traffic Mirror target.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The tags assigned to the Traffic Mirror target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags assigned to the Traffic Mirror target.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(networkLoadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorTarget)) {
            return false;
        }
        TrafficMirrorTarget other = (TrafficMirrorTarget) obj;
        return Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(networkLoadBalancerArn(), other.networkLoadBalancerArn())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrafficMirrorTarget").add("TrafficMirrorTargetId", trafficMirrorTargetId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("NetworkLoadBalancerArn", networkLoadBalancerArn())
                .add("Type", typeAsString()).add("Description", description()).add("OwnerId", ownerId()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "NetworkLoadBalancerArn":
            return Optional.ofNullable(clazz.cast(networkLoadBalancerArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorTarget, T> g) {
        return obj -> g.apply((TrafficMirrorTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficMirrorTarget> {
        /**
         * <p>
         * The ID of the Traffic Mirror target.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The ID of the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);

        /**
         * <p>
         * The network interface ID that is attached to the target.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface ID that is attached to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Network Load Balancer.
         * </p>
         * 
         * @param networkLoadBalancerArn
         *        The Amazon Resource Name (ARN) of the Network Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkLoadBalancerArn(String networkLoadBalancerArn);

        /**
         * <p>
         * The type of Traffic Mirror target.
         * </p>
         * 
         * @param type
         *        The type of Traffic Mirror target.
         * @see TrafficMirrorTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorTargetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of Traffic Mirror target.
         * </p>
         * 
         * @param type
         *        The type of Traffic Mirror target.
         * @see TrafficMirrorTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficMirrorTargetType
         */
        Builder type(TrafficMirrorTargetType type);

        /**
         * <p>
         * Information about the Traffic Mirror target.
         * </p>
         * 
         * @param description
         *        Information about the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the account that owns the Traffic Mirror target.
         * </p>
         * 
         * @param ownerId
         *        The ID of the account that owns the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror target.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror target.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror target.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String trafficMirrorTargetId;

        private String networkInterfaceId;

        private String networkLoadBalancerArn;

        private String type;

        private String description;

        private String ownerId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorTarget model) {
            trafficMirrorTargetId(model.trafficMirrorTargetId);
            networkInterfaceId(model.networkInterfaceId);
            networkLoadBalancerArn(model.networkLoadBalancerArn);
            type(model.type);
            description(model.description);
            ownerId(model.ownerId);
            tags(model.tags);
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getNetworkLoadBalancerArn() {
            return networkLoadBalancerArn;
        }

        @Override
        public final Builder networkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
            return this;
        }

        public final void setNetworkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TrafficMirrorTargetType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TrafficMirrorTarget build() {
            return new TrafficMirrorTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
