/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Image implements SdkPojo, Serializable, ToCopyableBuilder<Image.Builder, Image> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture")
                    .unmarshallLocationName("architecture").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate")
                    .unmarshallLocationName("creationDate").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::imageId))
            .setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId")
                    .unmarshallLocationName("imageId").build()).build();

    private static final SdkField<String> IMAGE_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::imageLocation))
            .setter(setter(Builder::imageLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLocation")
                    .unmarshallLocationName("imageLocation").build()).build();

    private static final SdkField<String> IMAGE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::imageTypeAsString))
            .setter(setter(Builder::imageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageType")
                    .unmarshallLocationName("imageType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::kernelId))
            .setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId")
                    .unmarshallLocationName("kernelId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerId")
                    .unmarshallLocationName("imageOwnerId").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::platformAsString))
            .setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform")
                    .unmarshallLocationName("platform").build()).build();

    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField
            .<List<ProductCode>> builder(MarshallingType.LIST)
            .getter(getter(Image::productCodes))
            .setter(setter(Builder::productCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes")
                    .unmarshallLocationName("productCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ProductCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProductCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> RAMDISK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::ramdiskId))
            .setter(setter(Builder::ramdiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamdiskId")
                    .unmarshallLocationName("ramdiskId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageState")
                    .unmarshallLocationName("imageState").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .getter(getter(Image::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping")
                    .unmarshallLocationName("blockDeviceMapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Boolean> ENA_SUPPORT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Image::enaSupport))
            .setter(setter(Builder::enaSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport")
                    .unmarshallLocationName("enaSupport").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::hypervisorAsString))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<String> IMAGE_OWNER_ALIAS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::imageOwnerAlias))
            .setter(setter(Builder::imageOwnerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageOwnerAlias")
                    .unmarshallLocationName("imageOwnerAlias").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> ROOT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::rootDeviceName))
            .setter(setter(Builder::rootDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceName")
                    .unmarshallLocationName("rootDeviceName").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType")
                    .unmarshallLocationName("rootDeviceType").build()).build();

    private static final SdkField<String> SRIOV_NET_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::sriovNetSupport))
            .setter(setter(Builder::sriovNetSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport")
                    .unmarshallLocationName("sriovNetSupport").build()).build();

    private static final SdkField<StateReason> STATE_REASON_FIELD = SdkField
            .<StateReason> builder(MarshallingType.SDK_POJO)
            .getter(getter(Image::stateReason))
            .setter(setter(Builder::stateReason))
            .constructor(StateReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason")
                    .unmarshallLocationName("stateReason").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Image::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Image::virtualizationTypeAsString))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType")
                    .unmarshallLocationName("virtualizationType").build()).build();

    private static final SdkField<Boolean> PUBLIC_LAUNCH_PERMISSIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Image::publicLaunchPermissions))
            .setter(setter(Builder::publicLaunchPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPublic")
                    .unmarshallLocationName("isPublic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            CREATION_DATE_FIELD, IMAGE_ID_FIELD, IMAGE_LOCATION_FIELD, IMAGE_TYPE_FIELD, KERNEL_ID_FIELD, OWNER_ID_FIELD,
            PLATFORM_FIELD, PRODUCT_CODES_FIELD, RAMDISK_ID_FIELD, STATE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DESCRIPTION_FIELD,
            ENA_SUPPORT_FIELD, HYPERVISOR_FIELD, IMAGE_OWNER_ALIAS_FIELD, NAME_FIELD, ROOT_DEVICE_NAME_FIELD,
            ROOT_DEVICE_TYPE_FIELD, SRIOV_NET_SUPPORT_FIELD, STATE_REASON_FIELD, TAGS_FIELD, VIRTUALIZATION_TYPE_FIELD,
            PUBLIC_LAUNCH_PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String architecture;

    private final String creationDate;

    private final String imageId;

    private final String imageLocation;

    private final String imageType;

    private final String kernelId;

    private final String ownerId;

    private final String platform;

    private final List<ProductCode> productCodes;

    private final String ramdiskId;

    private final String state;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String description;

    private final Boolean enaSupport;

    private final String hypervisor;

    private final String imageOwnerAlias;

    private final String name;

    private final String rootDeviceName;

    private final String rootDeviceType;

    private final String sriovNetSupport;

    private final StateReason stateReason;

    private final List<Tag> tags;

    private final String virtualizationType;

    private final Boolean publicLaunchPermissions;

    private Image(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.creationDate = builder.creationDate;
        this.imageId = builder.imageId;
        this.imageLocation = builder.imageLocation;
        this.imageType = builder.imageType;
        this.kernelId = builder.kernelId;
        this.ownerId = builder.ownerId;
        this.platform = builder.platform;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.state = builder.state;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.hypervisor = builder.hypervisor;
        this.imageOwnerAlias = builder.imageOwnerAlias;
        this.name = builder.name;
        this.rootDeviceName = builder.rootDeviceName;
        this.rootDeviceType = builder.rootDeviceType;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.stateReason = builder.stateReason;
        this.tags = builder.tags;
        this.virtualizationType = builder.virtualizationType;
        this.publicLaunchPermissions = builder.publicLaunchPermissions;
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public ArchitectureValues architecture() {
        return ArchitectureValues.fromValue(architecture);
    }

    /**
     * <p>
     * The architecture of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link ArchitectureValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The architecture of the image.
     * @see ArchitectureValues
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The date and time the image was created.
     * </p>
     * 
     * @return The date and time the image was created.
     */
    public String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The location of the AMI.
     * </p>
     * 
     * @return The location of the AMI.
     */
    public String imageLocation() {
        return imageLocation;
    }

    /**
     * <p>
     * The type of image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type of image.
     * @see ImageTypeValues
     */
    public ImageTypeValues imageType() {
        return ImageTypeValues.fromValue(imageType);
    }

    /**
     * <p>
     * The type of image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageType} will
     * return {@link ImageTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #imageTypeAsString}.
     * </p>
     * 
     * @return The type of image.
     * @see ImageTypeValues
     */
    public String imageTypeAsString() {
        return imageType;
    }

    /**
     * <p>
     * The kernel associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The kernel associated with the image, if any. Only applicable for machine images.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The AWS account ID of the image owner.
     * </p>
     * 
     * @return The AWS account ID of the image owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * This value is set for Windows AMIs; otherwise, it is blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return This value is set for Windows AMIs; otherwise, it is blank.
     * @see PlatformValues
     */
    public PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * This value is set for Windows AMIs; otherwise, it is blank.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return This value is set for Windows AMIs; otherwise, it is blank.
     * @see PlatformValues
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Any product codes associated with the AMI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any product codes associated with the AMI.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The RAM disk associated with the image, if any. Only applicable for machine images.
     * </p>
     * 
     * @return The RAM disk associated with the image, if any. Only applicable for machine images.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and
     * can be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the image is successfully
     *         registered and can be used to launch an instance.
     * @see ImageState
     */
    public ImageState state() {
        return ImageState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered and
     * can be used to launch an instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ImageState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the AMI. If the state is <code>available</code>, the image is successfully
     *         registered and can be used to launch an instance.
     * @see ImageState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Any block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The description of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The description of the AMI that was provided during image creation.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * The hypervisor type of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the image.
     * @see HypervisorType
     */
    public HypervisorType hypervisor() {
        return HypervisorType.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor type of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link HypervisorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor type of the image.
     * @see HypervisorType
     */
    public String hypervisorAsString() {
        return hypervisor;
    }

    /**
     * <p>
     * The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the AMI
     * owner.
     * </p>
     * 
     * @return The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the
     *         AMI owner.
     */
    public String imageOwnerAlias() {
        return imageOwnerAlias;
    }

    /**
     * <p>
     * The name of the AMI that was provided during image creation.
     * </p>
     * 
     * @return The name of the AMI that was provided during image creation.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public DeviceType rootDeviceType() {
        return DeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
     * @see DeviceType
     */
    public String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * <p>
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The reason for the state change.
     * </p>
     * 
     * @return The reason for the state change.
     */
    public StateReason stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * Any tags assigned to the image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the image.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of virtualization of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The type of virtualization of the AMI.
     * @see VirtualizationType
     */
    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The type of virtualization of the AMI.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The type of virtualization of the AMI.
     * @see VirtualizationType
     */
    public String virtualizationTypeAsString() {
        return virtualizationType;
    }

    /**
     * <p>
     * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
     * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
     * </p>
     * 
     * @return Indicates whether the image has public launch permissions. The value is <code>true</code> if this image
     *         has public launch permissions or <code>false</code> if it has only implicit and explicit launch
     *         permissions.
     */
    public Boolean publicLaunchPermissions() {
        return publicLaunchPermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(imageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(imageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageOwnerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publicLaunchPermissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image) obj;
        return Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(imageLocation(), other.imageLocation())
                && Objects.equals(imageTypeAsString(), other.imageTypeAsString()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(description(), other.description()) && Objects.equals(enaSupport(), other.enaSupport())
                && Objects.equals(hypervisorAsString(), other.hypervisorAsString())
                && Objects.equals(imageOwnerAlias(), other.imageOwnerAlias()) && Objects.equals(name(), other.name())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(tags(), other.tags())
                && Objects.equals(virtualizationTypeAsString(), other.virtualizationTypeAsString())
                && Objects.equals(publicLaunchPermissions(), other.publicLaunchPermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Image").add("Architecture", architectureAsString()).add("CreationDate", creationDate())
                .add("ImageId", imageId()).add("ImageLocation", imageLocation()).add("ImageType", imageTypeAsString())
                .add("KernelId", kernelId()).add("OwnerId", ownerId()).add("Platform", platformAsString())
                .add("ProductCodes", productCodes()).add("RamdiskId", ramdiskId()).add("State", stateAsString())
                .add("BlockDeviceMappings", blockDeviceMappings()).add("Description", description())
                .add("EnaSupport", enaSupport()).add("Hypervisor", hypervisorAsString())
                .add("ImageOwnerAlias", imageOwnerAlias()).add("Name", name()).add("RootDeviceName", rootDeviceName())
                .add("RootDeviceType", rootDeviceTypeAsString()).add("SriovNetSupport", sriovNetSupport())
                .add("StateReason", stateReason()).add("Tags", tags()).add("VirtualizationType", virtualizationTypeAsString())
                .add("PublicLaunchPermissions", publicLaunchPermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ImageLocation":
            return Optional.ofNullable(clazz.cast(imageLocation()));
        case "ImageType":
            return Optional.ofNullable(clazz.cast(imageTypeAsString()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "ProductCodes":
            return Optional.ofNullable(clazz.cast(productCodes()));
        case "RamdiskId":
            return Optional.ofNullable(clazz.cast(ramdiskId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EnaSupport":
            return Optional.ofNullable(clazz.cast(enaSupport()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisorAsString()));
        case "ImageOwnerAlias":
            return Optional.ofNullable(clazz.cast(imageOwnerAlias()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RootDeviceName":
            return Optional.ofNullable(clazz.cast(rootDeviceName()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "SriovNetSupport":
            return Optional.ofNullable(clazz.cast(sriovNetSupport()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationTypeAsString()));
        case "PublicLaunchPermissions":
            return Optional.ofNullable(clazz.cast(publicLaunchPermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Image> {
        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the image.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * The date and time the image was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time the image was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The location of the AMI.
         * </p>
         * 
         * @param imageLocation
         *        The location of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLocation(String imageLocation);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(String imageType);

        /**
         * <p>
         * The type of image.
         * </p>
         * 
         * @param imageType
         *        The type of image.
         * @see ImageTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTypeValues
         */
        Builder imageType(ImageTypeValues imageType);

        /**
         * <p>
         * The kernel associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param kernelId
         *        The kernel associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The AWS account ID of the image owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the image owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * This value is set for Windows AMIs; otherwise, it is blank.
         * </p>
         * 
         * @param platform
         *        This value is set for Windows AMIs; otherwise, it is blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * This value is set for Windows AMIs; otherwise, it is blank.
         * </p>
         * 
         * @param platform
         *        This value is set for Windows AMIs; otherwise, it is blank.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * 
         * @param productCodes
         *        Any product codes associated with the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * Any product codes associated with the AMI.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The RAM disk associated with the image, if any. Only applicable for machine images.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk associated with the image, if any. Only applicable for machine images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the AMI. If the state is <code>available</code>, the image is successfully registered
         * and can be used to launch an instance.
         * </p>
         * 
         * @param state
         *        The current state of the AMI. If the state is <code>available</code>, the image is successfully
         *        registered and can be used to launch an instance.
         * @see ImageState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageState
         */
        Builder state(ImageState state);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        Any block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * Any block device mapping entries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BlockDeviceMapping>.Builder} avoiding the
         * need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The description of the AMI that was provided during image creation.
         * </p>
         * 
         * @param description
         *        The description of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Specifies whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * The hypervisor type of the image.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor type of the image.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor type of the image.
         * @see HypervisorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorType
         */
        Builder hypervisor(HypervisorType hypervisor);

        /**
         * <p>
         * The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of the AMI
         * owner.
         * </p>
         * 
         * @param imageOwnerAlias
         *        The AWS account alias (for example, <code>amazon</code>, <code>self</code>) or the AWS account ID of
         *        the AMI owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageOwnerAlias(String imageOwnerAlias);

        /**
         * <p>
         * The name of the AMI that was provided during image creation.
         * </p>
         * 
         * @param name
         *        The name of the AMI that was provided during image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * </p>
         * 
         * @param rootDeviceType
         *        The type of root device used by the AMI. The AMI can use an EBS volume or an instance store volume.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder rootDeviceType(DeviceType rootDeviceType);

        /**
         * <p>
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * 
         * @param stateReason
         *        The reason for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(StateReason stateReason);

        /**
         * <p>
         * The reason for the state change.
         * </p>
         * This is a convenience that creates an instance of the {@link StateReason.Builder} avoiding the need to create
         * one manually via {@link StateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link StateReason.Builder#build()} is called immediately and its result
         * is passed to {@link #stateReason(StateReason)}.
         * 
         * @param stateReason
         *        a consumer that will call methods on {@link StateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateReason(StateReason)
         */
        default Builder stateReason(Consumer<StateReason.Builder> stateReason) {
            return stateReason(StateReason.builder().applyMutation(stateReason).build());
        }

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the image.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The type of virtualization of the AMI.
         * </p>
         * 
         * @param virtualizationType
         *        The type of virtualization of the AMI.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);

        /**
         * <p>
         * Indicates whether the image has public launch permissions. The value is <code>true</code> if this image has
         * public launch permissions or <code>false</code> if it has only implicit and explicit launch permissions.
         * </p>
         * 
         * @param publicLaunchPermissions
         *        Indicates whether the image has public launch permissions. The value is <code>true</code> if this
         *        image has public launch permissions or <code>false</code> if it has only implicit and explicit launch
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicLaunchPermissions(Boolean publicLaunchPermissions);
    }

    static final class BuilderImpl implements Builder {
        private String architecture;

        private String creationDate;

        private String imageId;

        private String imageLocation;

        private String imageType;

        private String kernelId;

        private String ownerId;

        private String platform;

        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();

        private String ramdiskId;

        private String state;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean enaSupport;

        private String hypervisor;

        private String imageOwnerAlias;

        private String name;

        private String rootDeviceName;

        private String rootDeviceType;

        private String sriovNetSupport;

        private StateReason stateReason;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String virtualizationType;

        private Boolean publicLaunchPermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            architecture(model.architecture);
            creationDate(model.creationDate);
            imageId(model.imageId);
            imageLocation(model.imageLocation);
            imageType(model.imageType);
            kernelId(model.kernelId);
            ownerId(model.ownerId);
            platform(model.platform);
            productCodes(model.productCodes);
            ramdiskId(model.ramdiskId);
            state(model.state);
            blockDeviceMappings(model.blockDeviceMappings);
            description(model.description);
            enaSupport(model.enaSupport);
            hypervisor(model.hypervisor);
            imageOwnerAlias(model.imageOwnerAlias);
            name(model.name);
            rootDeviceName(model.rootDeviceName);
            rootDeviceType(model.rootDeviceType);
            sriovNetSupport(model.sriovNetSupport);
            stateReason(model.stateReason);
            tags(model.tags);
            virtualizationType(model.virtualizationType);
            publicLaunchPermissions(model.publicLaunchPermissions);
        }

        public final String getArchitectureAsString() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImageLocation() {
            return imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getImageTypeAsString() {
            return imageType;
        }

        @Override
        public final Builder imageType(String imageType) {
            this.imageType = imageType;
            return this;
        }

        @Override
        public final Builder imageType(ImageTypeValues imageType) {
            this.imageType(imageType.toString());
            return this;
        }

        public final void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPlatformAsString() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getHypervisorAsString() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(HypervisorType hypervisor) {
            this.hypervisor(hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageOwnerAlias() {
            return imageOwnerAlias;
        }

        @Override
        public final Builder imageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
            return this;
        }

        public final void setImageOwnerAlias(String imageOwnerAlias) {
            this.imageOwnerAlias = imageOwnerAlias;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getRootDeviceTypeAsString() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(DeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final StateReason.Builder getStateReason() {
            return stateReason != null ? stateReason.toBuilder() : null;
        }

        @Override
        public final Builder stateReason(StateReason stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(StateReason.BuilderImpl stateReason) {
            this.stateReason = stateReason != null ? stateReason.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVirtualizationTypeAsString() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public final Boolean getPublicLaunchPermissions() {
            return publicLaunchPermissions;
        }

        @Override
        public final Builder publicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
            return this;
        }

        public final void setPublicLaunchPermissions(Boolean publicLaunchPermissions) {
            this.publicLaunchPermissions = publicLaunchPermissions;
        }

        @Override
        public Image build() {
            return new Image(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
