/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClientVpnEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<CreateClientVpnEndpointRequest.Builder, CreateClientVpnEndpointRequest> {
    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClientVpnEndpointRequest::clientCidrBlock))
            .setter(setter(Builder::clientCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock")
                    .unmarshallLocationName("ClientCidrBlock").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClientVpnEndpointRequest::serverCertificateArn))
            .setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn")
                    .unmarshallLocationName("ServerCertificateArn").build()).build();

    private static final SdkField<List<ClientVpnAuthenticationRequest>> AUTHENTICATION_OPTIONS_FIELD = SdkField
            .<List<ClientVpnAuthenticationRequest>> builder(MarshallingType.LIST)
            .getter(getter(CreateClientVpnEndpointRequest::authenticationOptions))
            .setter(setter(Builder::authenticationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication")
                    .unmarshallLocationName("Authentication").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClientVpnAuthenticationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClientVpnAuthenticationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<ConnectionLogOptions> CONNECTION_LOG_OPTIONS_FIELD = SdkField
            .<ConnectionLogOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateClientVpnEndpointRequest::connectionLogOptions))
            .setter(setter(Builder::connectionLogOptions))
            .constructor(ConnectionLogOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions")
                    .unmarshallLocationName("ConnectionLogOptions").build()).build();

    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateClientVpnEndpointRequest::dnsServers))
            .setter(setter(Builder::dnsServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServers")
                    .unmarshallLocationName("DnsServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClientVpnEndpointRequest::transportProtocolAsString))
            .setter(setter(Builder::transportProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol")
                    .unmarshallLocationName("TransportProtocol").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClientVpnEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateClientVpnEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .getter(getter(CreateClientVpnEndpointRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CIDR_BLOCK_FIELD,
            SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD, DNS_SERVERS_FIELD,
            TRANSPORT_PROTOCOL_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TAG_SPECIFICATIONS_FIELD));

    private final String clientCidrBlock;

    private final String serverCertificateArn;

    private final List<ClientVpnAuthenticationRequest> authenticationOptions;

    private final ConnectionLogOptions connectionLogOptions;

    private final List<String> dnsServers;

    private final String transportProtocol;

    private final String description;

    private final String clientToken;

    private final List<TagSpecification> tagSpecifications;

    private CreateClientVpnEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.clientCidrBlock = builder.clientCidrBlock;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.dnsServers = builder.dnsServers;
        this.transportProtocol = builder.transportProtocol;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot
     * overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add
     * manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block
     * should be /22 or greater.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range
     *         cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes
     *         that you add manually. The address range cannot be changed after the Client VPN endpoint has been
     *         created. The CIDR block should be /22 or greater.
     */
    public String clientCidrBlock() {
        return clientCidrBlock;
    }

    /**
     * <p>
     * The ARN of the server certificate. For more information, see the <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.
     * </p>
     * 
     * @return The ARN of the server certificate. For more information, see the <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.
     */
    public String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * <p>
     * Information about the authentication method to be used to authenticate clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the authentication method to be used to authenticate clients.
     */
    public List<ClientVpnAuthenticationRequest> authenticationOptions() {
        return authenticationOptions;
    }

    /**
     * <p>
     * Information about the client connection logging options.
     * </p>
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream.
     * The following information is logged:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection results (successful and unsuccessful)
     * </p>
     * </li>
     * <li>
     * <p>
     * Reasons for unsuccessful client connection requests
     * </p>
     * </li>
     * <li>
     * <p>
     * Client connection termination time
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the client connection logging options.</p>
     *         <p>
     *         If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
     *         stream. The following information is logged:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection results (successful and unsuccessful)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Reasons for unsuccessful client connection requests
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Client connection termination time
     *         </p>
     *         </li>
     */
    public ConnectionLogOptions connectionLogOptions() {
        return connectionLogOptions;
    }

    /**
     * <p>
     * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
     * servers. If no DNS server is specified, the DNS address of the VPC that is to be associated with Client VPN
     * endpoint is used as the DNS server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two
     *         DNS servers. If no DNS server is specified, the DNS address of the VPC that is to be associated with
     *         Client VPN endpoint is used as the DNS server.
     */
    public List<String> dnsServers() {
        return dnsServers;
    }

    /**
     * <p>
     * The transport protocol to be used by the VPN session.
     * </p>
     * <p>
     * Default value: <code>udp</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transportProtocol}
     * will return {@link TransportProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transportProtocolAsString}.
     * </p>
     * 
     * @return The transport protocol to be used by the VPN session.</p>
     *         <p>
     *         Default value: <code>udp</code>
     * @see TransportProtocol
     */
    public TransportProtocol transportProtocol() {
        return TransportProtocol.fromValue(transportProtocol);
    }

    /**
     * <p>
     * The transport protocol to be used by the VPN session.
     * </p>
     * <p>
     * Default value: <code>udp</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transportProtocol}
     * will return {@link TransportProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transportProtocolAsString}.
     * </p>
     * 
     * @return The transport protocol to be used by the VPN session.</p>
     *         <p>
     *         Default value: <code>udp</code>
     * @see TransportProtocol
     */
    public String transportProtocolAsString() {
        return transportProtocol;
    }

    /**
     * <p>
     * A brief description of the Client VPN endpoint.
     * </p>
     * 
     * @return A brief description of the Client VPN endpoint.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The tags to apply to the Client VPN endpoint during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the Client VPN endpoint during creation.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dnsServers());
        hashCode = 31 * hashCode + Objects.hashCode(transportProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClientVpnEndpointRequest)) {
            return false;
        }
        CreateClientVpnEndpointRequest other = (CreateClientVpnEndpointRequest) obj;
        return Objects.equals(clientCidrBlock(), other.clientCidrBlock())
                && Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && Objects.equals(authenticationOptions(), other.authenticationOptions())
                && Objects.equals(connectionLogOptions(), other.connectionLogOptions())
                && Objects.equals(dnsServers(), other.dnsServers())
                && Objects.equals(transportProtocolAsString(), other.transportProtocolAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClientVpnEndpointRequest").add("ClientCidrBlock", clientCidrBlock())
                .add("ServerCertificateArn", serverCertificateArn()).add("AuthenticationOptions", authenticationOptions())
                .add("ConnectionLogOptions", connectionLogOptions()).add("DnsServers", dnsServers())
                .add("TransportProtocol", transportProtocolAsString()).add("Description", description())
                .add("ClientToken", clientToken()).add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientCidrBlock":
            return Optional.ofNullable(clazz.cast(clientCidrBlock()));
        case "ServerCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "AuthenticationOptions":
            return Optional.ofNullable(clazz.cast(authenticationOptions()));
        case "ConnectionLogOptions":
            return Optional.ofNullable(clazz.cast(connectionLogOptions()));
        case "DnsServers":
            return Optional.ofNullable(clazz.cast(dnsServers()));
        case "TransportProtocol":
            return Optional.ofNullable(clazz.cast(transportProtocolAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClientVpnEndpointRequest, T> g) {
        return obj -> g.apply((CreateClientVpnEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClientVpnEndpointRequest> {
        /**
         * <p>
         * The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range cannot
         * overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add
         * manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block
         * should be /22 or greater.
         * </p>
         * 
         * @param clientCidrBlock
         *        The IPv4 address range, in CIDR notation, from which to assign client IP addresses. The address range
         *        cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes
         *        that you add manually. The address range cannot be changed after the Client VPN endpoint has been
         *        created. The CIDR block should be /22 or greater.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCidrBlock(String clientCidrBlock);

        /**
         * <p>
         * The ARN of the server certificate. For more information, see the <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.
         * </p>
         * 
         * @param serverCertificateArn
         *        The ARN of the server certificate. For more information, see the <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method to be used to authenticate clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> authenticationOptions);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method to be used to authenticate clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(ClientVpnAuthenticationRequest... authenticationOptions);

        /**
         * <p>
         * Information about the authentication method to be used to authenticate clients.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClientVpnAuthenticationRequest>.Builder}
         * avoiding the need to create one manually via {@link List<ClientVpnAuthenticationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClientVpnAuthenticationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationOptions(List<ClientVpnAuthenticationRequest>)}.
         * 
         * @param authenticationOptions
         *        a consumer that will call methods on {@link List<ClientVpnAuthenticationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationOptions(List<ClientVpnAuthenticationRequest>)
         */
        Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder>... authenticationOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * 
         * @param connectionLogOptions
         *        Information about the client connection logging options.</p>
         *        <p>
         *        If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs
         *        log stream. The following information is logged:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection results (successful and unsuccessful)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Reasons for unsuccessful client connection requests
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Client connection termination time
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions);

        /**
         * <p>
         * Information about the client connection logging options.
         * </p>
         * <p>
         * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log
         * stream. The following information is logged:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection results (successful and unsuccessful)
         * </p>
         * </li>
         * <li>
         * <p>
         * Reasons for unsuccessful client connection requests
         * </p>
         * </li>
         * <li>
         * <p>
         * Client connection termination time
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ConnectionLogOptions.Builder} avoiding the need
         * to create one manually via {@link ConnectionLogOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionLogOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionLogOptions(ConnectionLogOptions)}.
         * 
         * @param connectionLogOptions
         *        a consumer that will call methods on {@link ConnectionLogOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionLogOptions(ConnectionLogOptions)
         */
        default Builder connectionLogOptions(Consumer<ConnectionLogOptions.Builder> connectionLogOptions) {
            return connectionLogOptions(ConnectionLogOptions.builder().applyMutation(connectionLogOptions).build());
        }

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
         * servers. If no DNS server is specified, the DNS address of the VPC that is to be associated with Client VPN
         * endpoint is used as the DNS server.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to
         *        two DNS servers. If no DNS server is specified, the DNS address of the VPC that is to be associated
         *        with Client VPN endpoint is used as the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(Collection<String> dnsServers);

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to two DNS
         * servers. If no DNS server is specified, the DNS address of the VPC that is to be associated with Client VPN
         * endpoint is used as the DNS server.
         * </p>
         * 
         * @param dnsServers
         *        Information about the DNS servers to be used for DNS resolution. A Client VPN endpoint can have up to
         *        two DNS servers. If no DNS server is specified, the DNS address of the VPC that is to be associated
         *        with Client VPN endpoint is used as the DNS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServers(String... dnsServers);

        /**
         * <p>
         * The transport protocol to be used by the VPN session.
         * </p>
         * <p>
         * Default value: <code>udp</code>
         * </p>
         * 
         * @param transportProtocol
         *        The transport protocol to be used by the VPN session.</p>
         *        <p>
         *        Default value: <code>udp</code>
         * @see TransportProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransportProtocol
         */
        Builder transportProtocol(String transportProtocol);

        /**
         * <p>
         * The transport protocol to be used by the VPN session.
         * </p>
         * <p>
         * Default value: <code>udp</code>
         * </p>
         * 
         * @param transportProtocol
         *        The transport protocol to be used by the VPN session.</p>
         *        <p>
         *        Default value: <code>udp</code>
         * @see TransportProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransportProtocol
         */
        Builder transportProtocol(TransportProtocol transportProtocol);

        /**
         * <p>
         * A brief description of the Client VPN endpoint.
         * </p>
         * 
         * @param description
         *        A brief description of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Client VPN endpoint during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Client VPN endpoint during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Client VPN endpoint during creation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientCidrBlock;

        private String serverCertificateArn;

        private List<ClientVpnAuthenticationRequest> authenticationOptions = DefaultSdkAutoConstructList.getInstance();

        private ConnectionLogOptions connectionLogOptions;

        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();

        private String transportProtocol;

        private String description;

        private String clientToken;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClientVpnEndpointRequest model) {
            super(model);
            clientCidrBlock(model.clientCidrBlock);
            serverCertificateArn(model.serverCertificateArn);
            authenticationOptions(model.authenticationOptions);
            connectionLogOptions(model.connectionLogOptions);
            dnsServers(model.dnsServers);
            transportProtocol(model.transportProtocol);
            description(model.description);
            clientToken(model.clientToken);
            tagSpecifications(model.tagSpecifications);
        }

        public final String getClientCidrBlock() {
            return clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final Collection<ClientVpnAuthenticationRequest.Builder> getAuthenticationOptions() {
            return authenticationOptions != null ? authenticationOptions.stream().map(ClientVpnAuthenticationRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authenticationOptions(Collection<ClientVpnAuthenticationRequest> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(ClientVpnAuthenticationRequest... authenticationOptions) {
            authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(Consumer<ClientVpnAuthenticationRequest.Builder>... authenticationOptions) {
            authenticationOptions(Stream.of(authenticationOptions)
                    .map(c -> ClientVpnAuthenticationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthenticationOptions(Collection<ClientVpnAuthenticationRequest.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = ClientVpnAuthenticationRequestListCopier.copyFromBuilder(authenticationOptions);
        }

        public final ConnectionLogOptions.Builder getConnectionLogOptions() {
            return connectionLogOptions != null ? connectionLogOptions.toBuilder() : null;
        }

        @Override
        public final Builder connectionLogOptions(ConnectionLogOptions connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final void setConnectionLogOptions(ConnectionLogOptions.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        public final Collection<String> getDnsServers() {
            return dnsServers;
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String... dnsServers) {
            dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = ValueStringListCopier.copy(dnsServers);
        }

        public final String getTransportProtocolAsString() {
            return transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        @Override
        public final Builder transportProtocol(TransportProtocol transportProtocol) {
            this.transportProtocol(transportProtocol.toString());
            return this;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClientVpnEndpointRequest build() {
            return new CreateClientVpnEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
