/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TelemetryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VgwTelemetry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VgwTelemetry> {
    private static final SdkField<Integer> ACCEPTED_ROUTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VgwTelemetry.getter(VgwTelemetry::acceptedRouteCount)).setter(VgwTelemetry.setter(Builder::acceptedRouteCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptedRouteCount").unmarshallLocationName("acceptedRouteCount").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(VgwTelemetry.getter(VgwTelemetry::lastStatusChange)).setter(VgwTelemetry.setter(Builder::lastStatusChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStatusChange").unmarshallLocationName("lastStatusChange").build()}).build();
    private static final SdkField<String> OUTSIDE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VgwTelemetry.getter(VgwTelemetry::outsideIpAddress)).setter(VgwTelemetry.setter(Builder::outsideIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutsideIpAddress").unmarshallLocationName("outsideIpAddress").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VgwTelemetry.getter(VgwTelemetry::statusAsString)).setter(VgwTelemetry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VgwTelemetry.getter(VgwTelemetry::statusMessage)).setter(VgwTelemetry.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTED_ROUTE_COUNT_FIELD, LAST_STATUS_CHANGE_FIELD, OUTSIDE_IP_ADDRESS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer acceptedRouteCount;
    private final Instant lastStatusChange;
    private final String outsideIpAddress;
    private final String status;
    private final String statusMessage;

    private VgwTelemetry(BuilderImpl builder) {
        this.acceptedRouteCount = builder.acceptedRouteCount;
        this.lastStatusChange = builder.lastStatusChange;
        this.outsideIpAddress = builder.outsideIpAddress;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public Integer acceptedRouteCount() {
        return this.acceptedRouteCount;
    }

    public Instant lastStatusChange() {
        return this.lastStatusChange;
    }

    public String outsideIpAddress() {
        return this.outsideIpAddress;
    }

    public TelemetryStatus status() {
        return TelemetryStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedRouteCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.outsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VgwTelemetry)) {
            return false;
        }
        VgwTelemetry other = (VgwTelemetry)obj;
        return Objects.equals(this.acceptedRouteCount(), other.acceptedRouteCount()) && Objects.equals(this.lastStatusChange(), other.lastStatusChange()) && Objects.equals(this.outsideIpAddress(), other.outsideIpAddress()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"VgwTelemetry").add("AcceptedRouteCount", (Object)this.acceptedRouteCount()).add("LastStatusChange", (Object)this.lastStatusChange()).add("OutsideIpAddress", (Object)this.outsideIpAddress()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptedRouteCount": {
                return Optional.ofNullable(clazz.cast(this.acceptedRouteCount()));
            }
            case "LastStatusChange": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChange()));
            }
            case "OutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.outsideIpAddress()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VgwTelemetry, T> g) {
        return obj -> g.apply((VgwTelemetry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer acceptedRouteCount;
        private Instant lastStatusChange;
        private String outsideIpAddress;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VgwTelemetry model) {
            this.acceptedRouteCount(model.acceptedRouteCount);
            this.lastStatusChange(model.lastStatusChange);
            this.outsideIpAddress(model.outsideIpAddress);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Integer getAcceptedRouteCount() {
            return this.acceptedRouteCount;
        }

        @Override
        public final Builder acceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
            return this;
        }

        public final void setAcceptedRouteCount(Integer acceptedRouteCount) {
            this.acceptedRouteCount = acceptedRouteCount;
        }

        public final Instant getLastStatusChange() {
            return this.lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        public final String getOutsideIpAddress() {
            return this.outsideIpAddress;
        }

        @Override
        public final Builder outsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
            return this;
        }

        public final void setOutsideIpAddress(String outsideIpAddress) {
            this.outsideIpAddress = outsideIpAddress;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public VgwTelemetry build() {
            return new VgwTelemetry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VgwTelemetry> {
        public Builder acceptedRouteCount(Integer var1);

        public Builder lastStatusChange(Instant var1);

        public Builder outsideIpAddress(String var1);

        public Builder status(String var1);

        public Builder status(TelemetryStatus var1);

        public Builder statusMessage(String var1);
    }
}

