/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of On-Demand Instances in an EC2 Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OnDemandOptions implements SdkPojo, Serializable, ToCopyableBuilder<OnDemandOptions.Builder, OnDemandOptions> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OnDemandOptions::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy")
                    .unmarshallLocationName("allocationStrategy").build()).build();

    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OnDemandOptions::singleInstanceType))
            .setter(setter(Builder::singleInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType")
                    .unmarshallLocationName("singleInstanceType").build()).build();

    private static final SdkField<Boolean> SINGLE_AVAILABILITY_ZONE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OnDemandOptions::singleAvailabilityZone))
            .setter(setter(Builder::singleAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAvailabilityZone")
                    .unmarshallLocationName("singleAvailabilityZone").build()).build();

    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(OnDemandOptions::minTargetCapacity))
            .setter(setter(Builder::minTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity")
                    .unmarshallLocationName("minTargetCapacity").build()).build();

    private static final SdkField<String> MAX_TOTAL_PRICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(OnDemandOptions::maxTotalPrice))
            .setter(setter(Builder::maxTotalPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTotalPrice")
                    .unmarshallLocationName("maxTotalPrice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD,
            SINGLE_INSTANCE_TYPE_FIELD, SINGLE_AVAILABILITY_ZONE_FIELD, MIN_TARGET_CAPACITY_FIELD, MAX_TOTAL_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private final Boolean singleInstanceType;

    private final Boolean singleAvailabilityZone;

    private final Integer minTargetCapacity;

    private final String maxTotalPrice;

    private OnDemandOptions(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.singleInstanceType = builder.singleInstanceType;
        this.singleAvailabilityZone = builder.singleAvailabilityZone;
        this.minTargetCapacity = builder.minTargetCapacity;
        this.maxTotalPrice = builder.maxTotalPrice;
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override,
     * launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
     * <code>lowest-price</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link FleetOnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch
     *         template override, launching the highest priority first. If you do not specify a value, EC2 Fleet
     *         defaults to <code>lowest-price</code>.
     * @see FleetOnDemandAllocationStrategy
     */
    public FleetOnDemandAllocationStrategy allocationStrategy() {
        return FleetOnDemandAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If you
     * specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template override,
     * launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
     * <code>lowest-price</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link FleetOnDemandAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
     *         <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first.
     *         If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch
     *         template override, launching the highest priority first. If you do not specify a value, EC2 Fleet
     *         defaults to <code>lowest-price</code>.
     * @see FleetOnDemandAllocationStrategy
     */
    public String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
     * </p>
     * 
     * @return Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
     */
    public Boolean singleInstanceType() {
        return singleInstanceType;
    }

    /**
     * <p>
     * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
     * </p>
     * 
     * @return Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
     */
    public Boolean singleAvailabilityZone() {
        return singleAvailabilityZone;
    }

    /**
     * <p>
     * The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached,
     * the fleet launches no instances.
     * </p>
     * 
     * @return The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not
     *         reached, the fleet launches no instances.
     */
    public Integer minTargetCapacity() {
        return minTargetCapacity;
    }

    /**
     * <p>
     * The maximum amount per hour for On-Demand Instances that you're willing to pay.
     * </p>
     * 
     * @return The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    public String maxTotalPrice() {
        return maxTotalPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(singleAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(minTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxTotalPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnDemandOptions)) {
            return false;
        }
        OnDemandOptions other = (OnDemandOptions) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(singleInstanceType(), other.singleInstanceType())
                && Objects.equals(singleAvailabilityZone(), other.singleAvailabilityZone())
                && Objects.equals(minTargetCapacity(), other.minTargetCapacity())
                && Objects.equals(maxTotalPrice(), other.maxTotalPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OnDemandOptions").add("AllocationStrategy", allocationStrategyAsString())
                .add("SingleInstanceType", singleInstanceType()).add("SingleAvailabilityZone", singleAvailabilityZone())
                .add("MinTargetCapacity", minTargetCapacity()).add("MaxTotalPrice", maxTotalPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "SingleInstanceType":
            return Optional.ofNullable(clazz.cast(singleInstanceType()));
        case "SingleAvailabilityZone":
            return Optional.ofNullable(clazz.cast(singleAvailabilityZone()));
        case "MinTargetCapacity":
            return Optional.ofNullable(clazz.cast(minTargetCapacity()));
        case "MaxTotalPrice":
            return Optional.ofNullable(clazz.cast(maxTotalPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OnDemandOptions, T> g) {
        return obj -> g.apply((OnDemandOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OnDemandOptions> {
        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template
         * override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
         * <code>lowest-price</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each
         *        launch template override, launching the highest priority first. If you do not specify a value, EC2
         *        Fleet defaults to <code>lowest-price</code>.
         * @see FleetOnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOnDemandAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         * <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price first. If
         * you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each launch template
         * override, launching the highest priority first. If you do not specify a value, EC2 Fleet defaults to
         * <code>lowest-price</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        The order of the launch template overrides to use in fulfilling On-Demand capacity. If you specify
         *        <code>lowest-price</code>, EC2 Fleet uses price to determine the order, launching the lowest price
         *        first. If you specify <code>prioritized</code>, EC2 Fleet uses the priority that you assigned to each
         *        launch template override, launching the highest priority first. If you do not specify a value, EC2
         *        Fleet defaults to <code>lowest-price</code>.
         * @see FleetOnDemandAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetOnDemandAllocationStrategy
         */
        Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy);

        /**
         * <p>
         * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
         * </p>
         * 
         * @param singleInstanceType
         *        Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleInstanceType(Boolean singleInstanceType);

        /**
         * <p>
         * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
         * </p>
         * 
         * @param singleAvailabilityZone
         *        Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleAvailabilityZone(Boolean singleAvailabilityZone);

        /**
         * <p>
         * The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not
         * reached, the fleet launches no instances.
         * </p>
         * 
         * @param minTargetCapacity
         *        The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is
         *        not reached, the fleet launches no instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTargetCapacity(Integer minTargetCapacity);

        /**
         * <p>
         * The maximum amount per hour for On-Demand Instances that you're willing to pay.
         * </p>
         * 
         * @param maxTotalPrice
         *        The maximum amount per hour for On-Demand Instances that you're willing to pay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTotalPrice(String maxTotalPrice);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private Boolean singleInstanceType;

        private Boolean singleAvailabilityZone;

        private Integer minTargetCapacity;

        private String maxTotalPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(OnDemandOptions model) {
            allocationStrategy(model.allocationStrategy);
            singleInstanceType(model.singleInstanceType);
            singleAvailabilityZone(model.singleAvailabilityZone);
            minTargetCapacity(model.minTargetCapacity);
            maxTotalPrice(model.maxTotalPrice);
        }

        public final String getAllocationStrategyAsString() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(FleetOnDemandAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final Boolean getSingleInstanceType() {
            return singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        public final Boolean getSingleAvailabilityZone() {
            return singleAvailabilityZone;
        }

        @Override
        public final Builder singleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
            return this;
        }

        public final void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
            this.singleAvailabilityZone = singleAvailabilityZone;
        }

        public final Integer getMinTargetCapacity() {
            return minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        public final String getMaxTotalPrice() {
            return maxTotalPrice;
        }

        @Override
        public final Builder maxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
            return this;
        }

        public final void setMaxTotalPrice(String maxTotalPrice) {
            this.maxTotalPrice = maxTotalPrice;
        }

        @Override
        public OnDemandOptions build() {
            return new OnDemandOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
