/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an attachment between a resource and a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayAttachment.Builder, TransitGatewayAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::transitGatewayAttachmentId))
            .setter(setter(Builder::transitGatewayAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId")
                    .unmarshallLocationName("transitGatewayAttachmentId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::transitGatewayOwnerId))
            .setter(setter(Builder::transitGatewayOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayOwnerId")
                    .unmarshallLocationName("transitGatewayOwnerId").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::resourceOwnerId))
            .setter(setter(Builder::resourceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId")
                    .unmarshallLocationName("resourceOwnerId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayAttachment::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<TransitGatewayAttachmentAssociation> ASSOCIATION_FIELD = SdkField
            .<TransitGatewayAttachmentAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(TransitGatewayAttachment::association))
            .setter(setter(Builder::association))
            .constructor(TransitGatewayAttachmentAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association")
                    .unmarshallLocationName("association").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TransitGatewayAttachment::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(TransitGatewayAttachment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_OWNER_ID_FIELD,
            RESOURCE_OWNER_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, STATE_FIELD, ASSOCIATION_FIELD, CREATION_TIME_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAttachmentId;

    private final String transitGatewayId;

    private final String transitGatewayOwnerId;

    private final String resourceOwnerId;

    private final String resourceType;

    private final String resourceId;

    private final String state;

    private final TransitGatewayAttachmentAssociation association;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayId = builder.transitGatewayId;
        this.transitGatewayOwnerId = builder.transitGatewayOwnerId;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.state = builder.state;
        this.association = builder.association;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the attachment.
     * </p>
     * 
     * @return The ID of the attachment.
     */
    public String transitGatewayAttachmentId() {
        return transitGatewayAttachmentId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the transit gateway.
     * </p>
     * 
     * @return The ID of the AWS account that owns the transit gateway.
     */
    public String transitGatewayOwnerId() {
        return transitGatewayOwnerId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the resource.
     * </p>
     * 
     * @return The ID of the AWS account that owns the resource.
     */
    public String resourceOwnerId() {
        return resourceOwnerId;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see TransitGatewayAttachmentResourceType
     */
    public TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TransitGatewayAttachmentResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type.
     * @see TransitGatewayAttachmentResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state.
     * @see TransitGatewayAttachmentState
     */
    public TransitGatewayAttachmentState state() {
        return TransitGatewayAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The attachment state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state.
     * @see TransitGatewayAttachmentState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The association.
     * </p>
     * 
     * @return The association.
     */
    public TransitGatewayAttachmentAssociation association() {
        return association;
    }

    /**
     * <p>
     * The creation time.
     * </p>
     * 
     * @return The creation time.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The tags for the attachment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags for the attachment.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayAttachment)) {
            return false;
        }
        TransitGatewayAttachment other = (TransitGatewayAttachment) obj;
        return Objects.equals(transitGatewayAttachmentId(), other.transitGatewayAttachmentId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(transitGatewayOwnerId(), other.transitGatewayOwnerId())
                && Objects.equals(resourceOwnerId(), other.resourceOwnerId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(association(), other.association()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransitGatewayAttachment").add("TransitGatewayAttachmentId", transitGatewayAttachmentId())
                .add("TransitGatewayId", transitGatewayId()).add("TransitGatewayOwnerId", transitGatewayOwnerId())
                .add("ResourceOwnerId", resourceOwnerId()).add("ResourceType", resourceTypeAsString())
                .add("ResourceId", resourceId()).add("State", stateAsString()).add("Association", association())
                .add("CreationTime", creationTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAttachmentId":
            return Optional.ofNullable(clazz.cast(transitGatewayAttachmentId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "TransitGatewayOwnerId":
            return Optional.ofNullable(clazz.cast(transitGatewayOwnerId()));
        case "ResourceOwnerId":
            return Optional.ofNullable(clazz.cast(resourceOwnerId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayAttachment, T> g) {
        return obj -> g.apply((TransitGatewayAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayAttachment> {
        /**
         * <p>
         * The ID of the attachment.
         * </p>
         * 
         * @param transitGatewayAttachmentId
         *        The ID of the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAttachmentId(String transitGatewayAttachmentId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the AWS account that owns the transit gateway.
         * </p>
         * 
         * @param transitGatewayOwnerId
         *        The ID of the AWS account that owns the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayOwnerId(String transitGatewayOwnerId);

        /**
         * <p>
         * The ID of the AWS account that owns the resource.
         * </p>
         * 
         * @param resourceOwnerId
         *        The ID of the AWS account that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerId(String resourceOwnerId);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see TransitGatewayAttachmentResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentResourceType
         */
        Builder resourceType(TransitGatewayAttachmentResourceType resourceType);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param state
         *        The attachment state.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The attachment state.
         * </p>
         * 
         * @param state
         *        The attachment state.
         * @see TransitGatewayAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayAttachmentState
         */
        Builder state(TransitGatewayAttachmentState state);

        /**
         * <p>
         * The association.
         * </p>
         * 
         * @param association
         *        The association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(TransitGatewayAttachmentAssociation association);

        /**
         * <p>
         * The association.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayAttachmentAssociation.Builder}
         * avoiding the need to create one manually via {@link TransitGatewayAttachmentAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayAttachmentAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(TransitGatewayAttachmentAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link TransitGatewayAttachmentAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(TransitGatewayAttachmentAssociation)
         */
        default Builder association(Consumer<TransitGatewayAttachmentAssociation.Builder> association) {
            return association(TransitGatewayAttachmentAssociation.builder().applyMutation(association).build());
        }

        /**
         * <p>
         * The creation time.
         * </p>
         * 
         * @param creationTime
         *        The creation time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * 
         * @param tags
         *        The tags for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAttachmentId;

        private String transitGatewayId;

        private String transitGatewayOwnerId;

        private String resourceOwnerId;

        private String resourceType;

        private String resourceId;

        private String state;

        private TransitGatewayAttachmentAssociation association;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayAttachment model) {
            transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            transitGatewayId(model.transitGatewayId);
            transitGatewayOwnerId(model.transitGatewayOwnerId);
            resourceOwnerId(model.resourceOwnerId);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            state(model.state);
            association(model.association);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayAttachmentId() {
            return transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getTransitGatewayOwnerId() {
            return transitGatewayOwnerId;
        }

        @Override
        public final Builder transitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
            return this;
        }

        public final void setTransitGatewayOwnerId(String transitGatewayOwnerId) {
            this.transitGatewayOwnerId = transitGatewayOwnerId;
        }

        public final String getResourceOwnerId() {
            return resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayAttachmentState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final TransitGatewayAttachmentAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        @Override
        public final Builder association(TransitGatewayAttachmentAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(TransitGatewayAttachmentAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public TransitGatewayAttachment build() {
            return new TransitGatewayAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
