/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpnConnectionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpnConnectionRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpnConnectionRequest.getter(ModifyVpnConnectionRequest::vpnConnectionId)).setter(ModifyVpnConnectionRequest.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpnConnectionRequest.getter(ModifyVpnConnectionRequest::transitGatewayId)).setter(ModifyVpnConnectionRequest.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("TransitGatewayId").build()}).build();
    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpnConnectionRequest.getter(ModifyVpnConnectionRequest::vpnGatewayId)).setter(ModifyVpnConnectionRequest.setter(Builder::vpnGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId").unmarshallLocationName("VpnGatewayId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, VPN_GATEWAY_ID_FIELD));
    private final String vpnConnectionId;
    private final String transitGatewayId;
    private final String vpnGatewayId;

    private ModifyVpnConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.transitGatewayId = builder.transitGatewayId;
        this.vpnGatewayId = builder.vpnGatewayId;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public String transitGatewayId() {
        return this.transitGatewayId;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnConnectionRequest)) {
            return false;
        }
        ModifyVpnConnectionRequest other = (ModifyVpnConnectionRequest)((Object)obj);
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpnConnectionRequest").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("TransitGatewayId", (Object)this.transitGatewayId()).add("VpnGatewayId", (Object)this.vpnGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "VpnGatewayId": {
                return Optional.ofNullable(clazz.cast(this.vpnGatewayId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnConnectionRequest, T> g) {
        return obj -> g.apply((ModifyVpnConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String transitGatewayId;
        private String vpnGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnConnectionRequest model) {
            super(model);
            this.vpnConnectionId(model.vpnConnectionId);
            this.transitGatewayId(model.transitGatewayId);
            this.vpnGatewayId(model.vpnGatewayId);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnConnectionRequest build() {
            return new ModifyVpnConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpnConnectionRequest> {
        public Builder vpnConnectionId(String var1);

        public Builder transitGatewayId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

