/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DatafeedSubscriptionState;
import software.amazon.awssdk.services.ec2.model.SpotInstanceStateFault;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotDatafeedSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpotDatafeedSubscription> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotDatafeedSubscription.getter(SpotDatafeedSubscription::bucket)).setter(SpotDatafeedSubscription.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("bucket").build()}).build();
    private static final SdkField<SpotInstanceStateFault> FAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SpotDatafeedSubscription.getter(SpotDatafeedSubscription::fault)).setter(SpotDatafeedSubscription.setter(Builder::fault)).constructor(SpotInstanceStateFault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fault").unmarshallLocationName("fault").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotDatafeedSubscription.getter(SpotDatafeedSubscription::ownerId)).setter(SpotDatafeedSubscription.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotDatafeedSubscription.getter(SpotDatafeedSubscription::prefix)).setter(SpotDatafeedSubscription.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("prefix").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SpotDatafeedSubscription.getter(SpotDatafeedSubscription::stateAsString)).setter(SpotDatafeedSubscription.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, FAULT_FIELD, OWNER_ID_FIELD, PREFIX_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final SpotInstanceStateFault fault;
    private final String ownerId;
    private final String prefix;
    private final String state;

    private SpotDatafeedSubscription(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.fault = builder.fault;
        this.ownerId = builder.ownerId;
        this.prefix = builder.prefix;
        this.state = builder.state;
    }

    public String bucket() {
        return this.bucket;
    }

    public SpotInstanceStateFault fault() {
        return this.fault;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String prefix() {
        return this.prefix;
    }

    public DatafeedSubscriptionState state() {
        return DatafeedSubscriptionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.fault());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotDatafeedSubscription)) {
            return false;
        }
        SpotDatafeedSubscription other = (SpotDatafeedSubscription)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.fault(), other.fault()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"SpotDatafeedSubscription").add("Bucket", (Object)this.bucket()).add("Fault", (Object)this.fault()).add("OwnerId", (Object)this.ownerId()).add("Prefix", (Object)this.prefix()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Fault": {
                return Optional.ofNullable(clazz.cast(this.fault()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotDatafeedSubscription, T> g) {
        return obj -> g.apply((SpotDatafeedSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private SpotInstanceStateFault fault;
        private String ownerId;
        private String prefix;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotDatafeedSubscription model) {
            this.bucket(model.bucket);
            this.fault(model.fault);
            this.ownerId(model.ownerId);
            this.prefix(model.prefix);
            this.state(model.state);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return this.fault != null ? this.fault.toBuilder() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatafeedSubscriptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public SpotDatafeedSubscription build() {
            return new SpotDatafeedSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpotDatafeedSubscription> {
        public Builder bucket(String var1);

        public Builder fault(SpotInstanceStateFault var1);

        default public Builder fault(Consumer<SpotInstanceStateFault.Builder> fault) {
            return this.fault((SpotInstanceStateFault)((SpotInstanceStateFault.Builder)SpotInstanceStateFault.builder().applyMutation(fault)).build());
        }

        public Builder ownerId(String var1);

        public Builder prefix(String var1);

        public Builder state(String var1);

        public Builder state(DatafeedSubscriptionState var1);
    }
}

