/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a flow log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowLog implements SdkPojo, Serializable, ToCopyableBuilder<FlowLog.Builder, FlowLog> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FlowLog::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<String> DELIVER_LOGS_ERROR_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::deliverLogsErrorMessage))
            .setter(setter(Builder::deliverLogsErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsErrorMessage")
                    .unmarshallLocationName("deliverLogsErrorMessage").build()).build();

    private static final SdkField<String> DELIVER_LOGS_PERMISSION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::deliverLogsPermissionArn))
            .setter(setter(Builder::deliverLogsPermissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsPermissionArn")
                    .unmarshallLocationName("deliverLogsPermissionArn").build()).build();

    private static final SdkField<String> DELIVER_LOGS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::deliverLogsStatus))
            .setter(setter(Builder::deliverLogsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsStatus")
                    .unmarshallLocationName("deliverLogsStatus").build()).build();

    private static final SdkField<String> FLOW_LOG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::flowLogId))
            .setter(setter(Builder::flowLogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId")
                    .unmarshallLocationName("flowLogId").build()).build();

    private static final SdkField<String> FLOW_LOG_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::flowLogStatus))
            .setter(setter(Builder::flowLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogStatus")
                    .unmarshallLocationName("flowLogStatus").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::logGroupName))
            .setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName")
                    .unmarshallLocationName("logGroupName").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId")
                    .unmarshallLocationName("resourceId").build()).build();

    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::trafficTypeAsString))
            .setter(setter(Builder::trafficType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType")
                    .unmarshallLocationName("trafficType").build()).build();

    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::logDestinationTypeAsString))
            .setter(setter(Builder::logDestinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType")
                    .unmarshallLocationName("logDestinationType").build()).build();

    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::logDestination))
            .setter(setter(Builder::logDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination")
                    .unmarshallLocationName("logDestination").build()).build();

    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FlowLog::logFormat))
            .setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat")
                    .unmarshallLocationName("logFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            DELIVER_LOGS_ERROR_MESSAGE_FIELD, DELIVER_LOGS_PERMISSION_ARN_FIELD, DELIVER_LOGS_STATUS_FIELD, FLOW_LOG_ID_FIELD,
            FLOW_LOG_STATUS_FIELD, LOG_GROUP_NAME_FIELD, RESOURCE_ID_FIELD, TRAFFIC_TYPE_FIELD, LOG_DESTINATION_TYPE_FIELD,
            LOG_DESTINATION_FIELD, LOG_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String deliverLogsErrorMessage;

    private final String deliverLogsPermissionArn;

    private final String deliverLogsStatus;

    private final String flowLogId;

    private final String flowLogStatus;

    private final String logGroupName;

    private final String resourceId;

    private final String trafficType;

    private final String logDestinationType;

    private final String logDestination;

    private final String logFormat;

    private FlowLog(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.deliverLogsErrorMessage = builder.deliverLogsErrorMessage;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.deliverLogsStatus = builder.deliverLogsStatus;
        this.flowLogId = builder.flowLogId;
        this.flowLogStatus = builder.flowLogStatus;
        this.logGroupName = builder.logGroupName;
        this.resourceId = builder.resourceId;
        this.trafficType = builder.trafficType;
        this.logDestinationType = builder.logDestinationType;
        this.logDestination = builder.logDestination;
        this.logFormat = builder.logFormat;
    }

    /**
     * <p>
     * The date and time the flow log was created.
     * </p>
     * 
     * @return The date and time the flow log was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs throttling
     * has been applied for one or more network interfaces, or that you've reached the limit on the number of log groups
     * that you can create. <code>Access error</code> indicates that the IAM role associated with the flow log does not
     * have sufficient permissions to publish to CloudWatch Logs. <code>Unknown error</code> indicates an internal
     * error.
     * </p>
     * 
     * @return Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
     *         throttling has been applied for one or more network interfaces, or that you've reached the limit on the
     *         number of log groups that you can create. <code>Access error</code> indicates that the IAM role
     *         associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
     *         <code>Unknown error</code> indicates an internal error.
     */
    public String deliverLogsErrorMessage() {
        return deliverLogsErrorMessage;
    }

    /**
     * <p>
     * The ARN of the IAM role that posts logs to CloudWatch Logs.
     * </p>
     * 
     * @return The ARN of the IAM role that posts logs to CloudWatch Logs.
     */
    public String deliverLogsPermissionArn() {
        return deliverLogsPermissionArn;
    }

    /**
     * <p>
     * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * 
     * @return The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     */
    public String deliverLogsStatus() {
        return deliverLogsStatus;
    }

    /**
     * <p>
     * The flow log ID.
     * </p>
     * 
     * @return The flow log ID.
     */
    public String flowLogId() {
        return flowLogId;
    }

    /**
     * <p>
     * The status of the flow log (<code>ACTIVE</code>).
     * </p>
     * 
     * @return The status of the flow log (<code>ACTIVE</code>).
     */
    public String flowLogStatus() {
        return flowLogStatus;
    }

    /**
     * <p>
     * The name of the flow log group.
     * </p>
     * 
     * @return The name of the flow log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The ID of the resource on which the flow log was created.
     * </p>
     * 
     * @return The ID of the resource on which the flow log was created.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return The type of traffic captured for the flow log.
     * @see TrafficType
     */
    public TrafficType trafficType() {
        return TrafficType.fromValue(trafficType);
    }

    /**
     * <p>
     * The type of traffic captured for the flow log.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trafficType} will
     * return {@link TrafficType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trafficTypeAsString}.
     * </p>
     * 
     * @return The type of traffic captured for the flow log.
     * @see TrafficType
     */
    public String trafficTypeAsString() {
        return trafficType;
    }

    /**
     * <p>
     * Specifies the type of destination to which the flow log data is published. Flow log data can be published to
     * CloudWatch Logs or Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #logDestinationType} will return {@link LogDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #logDestinationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of destination to which the flow log data is published. Flow log data can be published
     *         to CloudWatch Logs or Amazon S3.
     * @see LogDestinationType
     */
    public LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(logDestinationType);
    }

    /**
     * <p>
     * Specifies the type of destination to which the flow log data is published. Flow log data can be published to
     * CloudWatch Logs or Amazon S3.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #logDestinationType} will return {@link LogDestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #logDestinationTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of destination to which the flow log data is published. Flow log data can be published
     *         to CloudWatch Logs or Amazon S3.
     * @see LogDestinationType
     */
    public String logDestinationTypeAsString() {
        return logDestinationType;
    }

    /**
     * <p>
     * Specifies the destination to which the flow log data is published. Flow log data can be published to an
     * CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs, this element
     * indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which the data is published. If the
     * flow log publishes to Amazon S3, this element indicates the ARN of the Amazon S3 bucket to which the data is
     * published.
     * </p>
     * 
     * @return Specifies the destination to which the flow log data is published. Flow log data can be published to an
     *         CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs, this
     *         element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which the data is
     *         published. If the flow log publishes to Amazon S3, this element indicates the ARN of the Amazon S3 bucket
     *         to which the data is published.
     */
    public String logDestination() {
        return logDestination;
    }

    /**
     * <p>
     * The format of the flow log record.
     * </p>
     * 
     * @return The format of the flow log record.
     */
    public String logFormat() {
        return logFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deliverLogsErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliverLogsStatus());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogId());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogStatus());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logDestination());
        hashCode = 31 * hashCode + Objects.hashCode(logFormat());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowLog)) {
            return false;
        }
        FlowLog other = (FlowLog) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deliverLogsErrorMessage(), other.deliverLogsErrorMessage())
                && Objects.equals(deliverLogsPermissionArn(), other.deliverLogsPermissionArn())
                && Objects.equals(deliverLogsStatus(), other.deliverLogsStatus())
                && Objects.equals(flowLogId(), other.flowLogId()) && Objects.equals(flowLogStatus(), other.flowLogStatus())
                && Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(trafficTypeAsString(), other.trafficTypeAsString())
                && Objects.equals(logDestinationTypeAsString(), other.logDestinationTypeAsString())
                && Objects.equals(logDestination(), other.logDestination()) && Objects.equals(logFormat(), other.logFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FlowLog").add("CreationTime", creationTime())
                .add("DeliverLogsErrorMessage", deliverLogsErrorMessage())
                .add("DeliverLogsPermissionArn", deliverLogsPermissionArn()).add("DeliverLogsStatus", deliverLogsStatus())
                .add("FlowLogId", flowLogId()).add("FlowLogStatus", flowLogStatus()).add("LogGroupName", logGroupName())
                .add("ResourceId", resourceId()).add("TrafficType", trafficTypeAsString())
                .add("LogDestinationType", logDestinationTypeAsString()).add("LogDestination", logDestination())
                .add("LogFormat", logFormat()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DeliverLogsErrorMessage":
            return Optional.ofNullable(clazz.cast(deliverLogsErrorMessage()));
        case "DeliverLogsPermissionArn":
            return Optional.ofNullable(clazz.cast(deliverLogsPermissionArn()));
        case "DeliverLogsStatus":
            return Optional.ofNullable(clazz.cast(deliverLogsStatus()));
        case "FlowLogId":
            return Optional.ofNullable(clazz.cast(flowLogId()));
        case "FlowLogStatus":
            return Optional.ofNullable(clazz.cast(flowLogStatus()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "TrafficType":
            return Optional.ofNullable(clazz.cast(trafficTypeAsString()));
        case "LogDestinationType":
            return Optional.ofNullable(clazz.cast(logDestinationTypeAsString()));
        case "LogDestination":
            return Optional.ofNullable(clazz.cast(logDestination()));
        case "LogFormat":
            return Optional.ofNullable(clazz.cast(logFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowLog, T> g) {
        return obj -> g.apply((FlowLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowLog> {
        /**
         * <p>
         * The date and time the flow log was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the flow log was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
         * throttling has been applied for one or more network interfaces, or that you've reached the limit on the
         * number of log groups that you can create. <code>Access error</code> indicates that the IAM role associated
         * with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
         * <code>Unknown error</code> indicates an internal error.
         * </p>
         * 
         * @param deliverLogsErrorMessage
         *        Information about the error that occurred. <code>Rate limited</code> indicates that CloudWatch Logs
         *        throttling has been applied for one or more network interfaces, or that you've reached the limit on
         *        the number of log groups that you can create. <code>Access error</code> indicates that the IAM role
         *        associated with the flow log does not have sufficient permissions to publish to CloudWatch Logs.
         *        <code>Unknown error</code> indicates an internal error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsErrorMessage(String deliverLogsErrorMessage);

        /**
         * <p>
         * The ARN of the IAM role that posts logs to CloudWatch Logs.
         * </p>
         * 
         * @param deliverLogsPermissionArn
         *        The ARN of the IAM role that posts logs to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsPermissionArn(String deliverLogsPermissionArn);

        /**
         * <p>
         * The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
         * </p>
         * 
         * @param deliverLogsStatus
         *        The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverLogsStatus(String deliverLogsStatus);

        /**
         * <p>
         * The flow log ID.
         * </p>
         * 
         * @param flowLogId
         *        The flow log ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogId(String flowLogId);

        /**
         * <p>
         * The status of the flow log (<code>ACTIVE</code>).
         * </p>
         * 
         * @param flowLogStatus
         *        The status of the flow log (<code>ACTIVE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogStatus(String flowLogStatus);

        /**
         * <p>
         * The name of the flow log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the flow log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The ID of the resource on which the flow log was created.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource on which the flow log was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of traffic captured for the flow log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic captured for the flow log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * The type of traffic captured for the flow log.
         * </p>
         * 
         * @param trafficType
         *        The type of traffic captured for the flow log.
         * @see TrafficType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficType
         */
        Builder trafficType(TrafficType trafficType);

        /**
         * <p>
         * Specifies the type of destination to which the flow log data is published. Flow log data can be published to
         * CloudWatch Logs or Amazon S3.
         * </p>
         * 
         * @param logDestinationType
         *        Specifies the type of destination to which the flow log data is published. Flow log data can be
         *        published to CloudWatch Logs or Amazon S3.
         * @see LogDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestinationType
         */
        Builder logDestinationType(String logDestinationType);

        /**
         * <p>
         * Specifies the type of destination to which the flow log data is published. Flow log data can be published to
         * CloudWatch Logs or Amazon S3.
         * </p>
         * 
         * @param logDestinationType
         *        Specifies the type of destination to which the flow log data is published. Flow log data can be
         *        published to CloudWatch Logs or Amazon S3.
         * @see LogDestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDestinationType
         */
        Builder logDestinationType(LogDestinationType logDestinationType);

        /**
         * <p>
         * Specifies the destination to which the flow log data is published. Flow log data can be published to an
         * CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs, this element
         * indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which the data is published. If
         * the flow log publishes to Amazon S3, this element indicates the ARN of the Amazon S3 bucket to which the data
         * is published.
         * </p>
         * 
         * @param logDestination
         *        Specifies the destination to which the flow log data is published. Flow log data can be published to
         *        an CloudWatch Logs log group or an Amazon S3 bucket. If the flow log publishes to CloudWatch Logs,
         *        this element indicates the Amazon Resource Name (ARN) of the CloudWatch Logs log group to which the
         *        data is published. If the flow log publishes to Amazon S3, this element indicates the ARN of the
         *        Amazon S3 bucket to which the data is published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDestination(String logDestination);

        /**
         * <p>
         * The format of the flow log record.
         * </p>
         * 
         * @param logFormat
         *        The format of the flow log record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFormat(String logFormat);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String deliverLogsErrorMessage;

        private String deliverLogsPermissionArn;

        private String deliverLogsStatus;

        private String flowLogId;

        private String flowLogStatus;

        private String logGroupName;

        private String resourceId;

        private String trafficType;

        private String logDestinationType;

        private String logDestination;

        private String logFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowLog model) {
            creationTime(model.creationTime);
            deliverLogsErrorMessage(model.deliverLogsErrorMessage);
            deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            deliverLogsStatus(model.deliverLogsStatus);
            flowLogId(model.flowLogId);
            flowLogStatus(model.flowLogStatus);
            logGroupName(model.logGroupName);
            resourceId(model.resourceId);
            trafficType(model.trafficType);
            logDestinationType(model.logDestinationType);
            logDestination(model.logDestination);
            logFormat(model.logFormat);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDeliverLogsErrorMessage() {
            return deliverLogsErrorMessage;
        }

        @Override
        public final Builder deliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
            return this;
        }

        public final void setDeliverLogsErrorMessage(String deliverLogsErrorMessage) {
            this.deliverLogsErrorMessage = deliverLogsErrorMessage;
        }

        public final String getDeliverLogsPermissionArn() {
            return deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getDeliverLogsStatus() {
            return deliverLogsStatus;
        }

        @Override
        public final Builder deliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
            return this;
        }

        public final void setDeliverLogsStatus(String deliverLogsStatus) {
            this.deliverLogsStatus = deliverLogsStatus;
        }

        public final String getFlowLogId() {
            return flowLogId;
        }

        @Override
        public final Builder flowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
            return this;
        }

        public final void setFlowLogId(String flowLogId) {
            this.flowLogId = flowLogId;
        }

        public final String getFlowLogStatus() {
            return flowLogStatus;
        }

        @Override
        public final Builder flowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
            return this;
        }

        public final void setFlowLogStatus(String flowLogStatus) {
            this.flowLogStatus = flowLogStatus;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTrafficTypeAsString() {
            return trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        public final String getLogDestinationTypeAsString() {
            return logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        public final String getLogDestination() {
            return logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        public final String getLogFormat() {
            return logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public FlowLog build() {
            return new FlowLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
