/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Phase1EncryptionAlgorithmsRequestListCopier {
    static List<Phase1EncryptionAlgorithmsRequestListValue> copy(
            Collection<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithmsRequestListParam) {
        if (phase1EncryptionAlgorithmsRequestListParam == null
                || phase1EncryptionAlgorithmsRequestListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<Phase1EncryptionAlgorithmsRequestListValue> phase1EncryptionAlgorithmsRequestListParamCopy = new ArrayList<>(
                phase1EncryptionAlgorithmsRequestListParam);
        return Collections.unmodifiableList(phase1EncryptionAlgorithmsRequestListParamCopy);
    }

    static List<Phase1EncryptionAlgorithmsRequestListValue> copyFromBuilder(
            Collection<? extends Phase1EncryptionAlgorithmsRequestListValue.Builder> phase1EncryptionAlgorithmsRequestListParam) {
        if (phase1EncryptionAlgorithmsRequestListParam == null) {
            return null;
        }
        return copy(phase1EncryptionAlgorithmsRequestListParam.stream()
                .map(Phase1EncryptionAlgorithmsRequestListValue.Builder::build).collect(toList()));
    }
}
