/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnConnectionOptionsSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<VpnConnectionOptionsSpecification.Builder, VpnConnectionOptionsSpecification> {
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VpnConnectionOptionsSpecification::staticRoutesOnly))
            .setter(setter(Builder::staticRoutesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly")
                    .unmarshallLocationName("staticRoutesOnly").build()).build();

    private static final SdkField<List<VpnTunnelOptionsSpecification>> TUNNEL_OPTIONS_FIELD = SdkField
            .<List<VpnTunnelOptionsSpecification>> builder(MarshallingType.LIST)
            .getter(getter(VpnConnectionOptionsSpecification::tunnelOptions))
            .setter(setter(Builder::tunnelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions")
                    .unmarshallLocationName("TunnelOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpnTunnelOptionsSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpnTunnelOptionsSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_ROUTES_ONLY_FIELD,
            TUNNEL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean staticRoutesOnly;

    private final List<VpnTunnelOptionsSpecification> tunnelOptions;

    private VpnConnectionOptionsSpecification(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    /**
     * <p>
     * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a device
     * that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to create a
     * static route.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
     *         device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a>
     *         to create a static route.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    /**
     * <p>
     * The tunnel options for the VPN connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tunnel options for the VPN connection.
     */
    public List<VpnTunnelOptionsSpecification> tunnelOptions() {
        return tunnelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptionsSpecification)) {
            return false;
        }
        VpnConnectionOptionsSpecification other = (VpnConnectionOptionsSpecification) obj;
        return Objects.equals(staticRoutesOnly(), other.staticRoutesOnly())
                && Objects.equals(tunnelOptions(), other.tunnelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VpnConnectionOptionsSpecification").add("StaticRoutesOnly", staticRoutesOnly())
                .add("TunnelOptions", tunnelOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticRoutesOnly":
            return Optional.ofNullable(clazz.cast(staticRoutesOnly()));
        case "TunnelOptions":
            return Optional.ofNullable(clazz.cast(tunnelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnConnectionOptionsSpecification, T> g) {
        return obj -> g.apply((VpnConnectionOptionsSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnConnectionOptionsSpecification> {
        /**
         * <p>
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for a
         * device that does not support BGP, you must specify <code>true</code>. Use <a>CreateVpnConnectionRoute</a> to
         * create a static route.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param staticRoutesOnly
         *        Indicate whether the VPN connection uses static routes only. If you are creating a VPN connection for
         *        a device that does not support BGP, you must specify <code>true</code>. Use
         *        <a>CreateVpnConnectionRoute</a> to create a static route.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * 
         * @param tunnelOptions
         *        The tunnel options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions);

        /**
         * <p>
         * The tunnel options for the VPN connection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpnTunnelOptionsSpecification>.Builder}
         * avoiding the need to create one manually via {@link List<VpnTunnelOptionsSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpnTunnelOptionsSpecification>.Builder#build()} is called
         * immediately and its result is passed to {@link #tunnelOptions(List<VpnTunnelOptionsSpecification>)}.
         * 
         * @param tunnelOptions
         *        a consumer that will call methods on {@link List<VpnTunnelOptionsSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelOptions(List<VpnTunnelOptionsSpecification>)
         */
        Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder>... tunnelOptions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean staticRoutesOnly;

        private List<VpnTunnelOptionsSpecification> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptionsSpecification model) {
            staticRoutesOnly(model.staticRoutesOnly);
            tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        public final Collection<VpnTunnelOptionsSpecification.Builder> getTunnelOptions() {
            return tunnelOptions != null ? tunnelOptions.stream().map(VpnTunnelOptionsSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tunnelOptions(Collection<VpnTunnelOptionsSpecification> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(VpnTunnelOptionsSpecification... tunnelOptions) {
            tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<VpnTunnelOptionsSpecification.Builder>... tunnelOptions) {
            tunnelOptions(Stream.of(tunnelOptions).map(c -> VpnTunnelOptionsSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelOptions(Collection<VpnTunnelOptionsSpecification.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = VpnTunnelOptionsSpecificationsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        public VpnConnectionOptionsSpecification build() {
            return new VpnConnectionOptionsSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
