/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointsRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteVpcEndpointsRequest.Builder, DeleteVpcEndpointsRequest> {
    private static final SdkField<List<String>> VPC_ENDPOINT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteVpcEndpointsRequest::vpcEndpointIds))
            .setter(setter(Builder::vpcEndpointIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId")
                    .unmarshallLocationName("VpcEndpointId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_IDS_FIELD));

    private final List<String> vpcEndpointIds;

    private DeleteVpcEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    /**
     * <p>
     * One or more VPC endpoint IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more VPC endpoint IDs.
     */
    public List<String> vpcEndpointIds() {
        return vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointsRequest)) {
            return false;
        }
        DeleteVpcEndpointsRequest other = (DeleteVpcEndpointsRequest) obj;
        return Objects.equals(vpcEndpointIds(), other.vpcEndpointIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteVpcEndpointsRequest").add("VpcEndpointIds", vpcEndpointIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointIds":
            return Optional.ofNullable(clazz.cast(vpcEndpointIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointsRequest, T> g) {
        return obj -> g.apply((DeleteVpcEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVpcEndpointsRequest> {
        /**
         * <p>
         * One or more VPC endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more VPC endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(Collection<String> vpcEndpointIds);

        /**
         * <p>
         * One or more VPC endpoint IDs.
         * </p>
         * 
         * @param vpcEndpointIds
         *        One or more VPC endpoint IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointIds(String... vpcEndpointIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> vpcEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointsRequest model) {
            super(model);
            vpcEndpointIds(model.vpcEndpointIds);
        }

        public final Collection<String> getVpcEndpointIds() {
            return vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String... vpcEndpointIds) {
            vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointsRequest build() {
            return new DeleteVpcEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
