/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendSerialConsoleSshPublicKeyResponse extends Ec2InstanceConnectResponse implements
        ToCopyableBuilder<SendSerialConsoleSshPublicKeyResponse.Builder, SendSerialConsoleSshPublicKeyResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(SendSerialConsoleSshPublicKeyResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Boolean> SUCCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Success").getter(getter(SendSerialConsoleSshPublicKeyResponse::success))
            .setter(setter(Builder::success))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Success").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            SUCCESS_FIELD));

    private final String requestId;

    private final Boolean success;

    private SendSerialConsoleSshPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.success = builder.success;
    }

    /**
     * <p>
     * The ID of the request. Please provide this ID when contacting AWS Support for assistance.
     * </p>
     * 
     * @return The ID of the request. Please provide this ID when contacting AWS Support for assistance.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * Is true if the request succeeds and an error otherwise.
     * </p>
     * 
     * @return Is true if the request succeeds and an error otherwise.
     */
    public final Boolean success() {
        return success;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(success());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendSerialConsoleSshPublicKeyResponse)) {
            return false;
        }
        SendSerialConsoleSshPublicKeyResponse other = (SendSerialConsoleSshPublicKeyResponse) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(success(), other.success());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendSerialConsoleSshPublicKeyResponse").add("RequestId", requestId()).add("Success", success())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Success":
            return Optional.ofNullable(clazz.cast(success()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendSerialConsoleSshPublicKeyResponse, T> g) {
        return obj -> g.apply((SendSerialConsoleSshPublicKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2InstanceConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SendSerialConsoleSshPublicKeyResponse> {
        /**
         * <p>
         * The ID of the request. Please provide this ID when contacting AWS Support for assistance.
         * </p>
         * 
         * @param requestId
         *        The ID of the request. Please provide this ID when contacting AWS Support for assistance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * Is true if the request succeeds and an error otherwise.
         * </p>
         * 
         * @param success
         *        Is true if the request succeeds and an error otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder success(Boolean success);
    }

    static final class BuilderImpl extends Ec2InstanceConnectResponse.BuilderImpl implements Builder {
        private String requestId;

        private Boolean success;

        private BuilderImpl() {
        }

        private BuilderImpl(SendSerialConsoleSshPublicKeyResponse model) {
            super(model);
            requestId(model.requestId);
            success(model.success);
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Boolean getSuccess() {
            return success;
        }

        public final void setSuccess(Boolean success) {
            this.success = success;
        }

        @Override
        public final Builder success(Boolean success) {
            this.success = success;
            return this;
        }

        @Override
        public SendSerialConsoleSshPublicKeyResponse build() {
            return new SendSerialConsoleSshPublicKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
