/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse;

/**
 * Service client for accessing EC2 Instance Connect asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon EC2 Instance Connect enables system administrators to publish one-time use SSH public keys to EC2, providing
 * users a simple and secure way to connect to their instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Ec2InstanceConnectAsyncClient extends SdkClient {
    String SERVICE_NAME = "ec2-instance-connect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ec2-instance-connect";

    /**
     * Create a {@link Ec2InstanceConnectAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Ec2InstanceConnectAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Ec2InstanceConnectAsyncClient}.
     */
    static Ec2InstanceConnectAsyncClientBuilder builder() {
        return new DefaultEc2InstanceConnectAsyncClientBuilder();
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60
     * seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to
     * your Linux instance using EC2 Instance Connect</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param sendSshPublicKeyRequest
     * @return A Java Future containing the result of the SendSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Either your AWS credentials are not valid or you do not have access to the EC2
     *         instance.</li>
     *         <li>InvalidArgsException One of the parameters is not valid.</li>
     *         <li>ServiceException The service encountered an error. Follow the instructions in the error message and
     *         try again.</li>
     *         <li>ThrottlingException The requests were made too frequently and have been throttled. Wait a while and
     *         try again. To increase the limit on your request frequency, contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException The specified instance was not found.</li>
     *         <li>Ec2InstanceStateInvalidException Unable to connect because the instance is not in a valid state.
     *         Connecting to a stopped or terminated instance is not supported. If the instance is stopped, start your
     *         instance, and try to connect again.</li>
     *         <li>Ec2InstanceUnavailableException The instance is currently unavailable. Wait a few minutes and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSshPublicKeyResponse> sendSSHPublicKey(SendSshPublicKeyRequest sendSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60
     * seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to
     * your Linux instance using EC2 Instance Connect</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendSshPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link SendSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param sendSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link SendSSHPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendSSHPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Either your AWS credentials are not valid or you do not have access to the EC2
     *         instance.</li>
     *         <li>InvalidArgsException One of the parameters is not valid.</li>
     *         <li>ServiceException The service encountered an error. Follow the instructions in the error message and
     *         try again.</li>
     *         <li>ThrottlingException The requests were made too frequently and have been throttled. Wait a while and
     *         try again. To increase the limit on your request frequency, contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException The specified instance was not found.</li>
     *         <li>Ec2InstanceStateInvalidException Unable to connect because the instance is not in a valid state.
     *         Connecting to a stopped or terminated instance is not supported. If the instance is stopped, start your
     *         instance, and try to connect again.</li>
     *         <li>Ec2InstanceUnavailableException The instance is currently unavailable. Wait a few minutes and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSshPublicKeyResponse> sendSSHPublicKey(
            Consumer<SendSshPublicKeyRequest.Builder> sendSshPublicKeyRequest) {
        return sendSSHPublicKey(SendSshPublicKeyRequest.builder().applyMutation(sendSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60
     * seconds to establish a serial console connection to the instance using SSH. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-serial-console.html">EC2 Serial Console</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param sendSerialConsoleSshPublicKeyRequest
     * @return A Java Future containing the result of the SendSerialConsoleSSHPublicKey operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Either your AWS credentials are not valid or you do not have access to the EC2
     *         instance.</li>
     *         <li>SerialConsoleAccessDisabledException Your account is not authorized to use the EC2 Serial Console. To
     *         authorize your account, run the EnableSerialConsoleAccess API. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html"
     *         >EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.</li>
     *         <li>InvalidArgsException One of the parameters is not valid.</li>
     *         <li>ServiceException The service encountered an error. Follow the instructions in the error message and
     *         try again.</li>
     *         <li>ThrottlingException The requests were made too frequently and have been throttled. Wait a while and
     *         try again. To increase the limit on your request frequency, contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException The specified instance was not found.</li>
     *         <li>Ec2InstanceTypeInvalidException The instance type is not supported for connecting via the serial
     *         console. Only Nitro instance types are currently supported.</li>
     *         <li>SerialConsoleSessionLimitExceededException The instance currently has 1 active serial console
     *         session. Only 1 session is supported at a time.</li>
     *         <li>SerialConsoleSessionUnavailableException Unable to start a serial console session. Please try again.</li>
     *         <li>Ec2InstanceStateInvalidException Unable to connect because the instance is not in a valid state.
     *         Connecting to a stopped or terminated instance is not supported. If the instance is stopped, start your
     *         instance, and try to connect again.</li>
     *         <li>Ec2InstanceUnavailableException The instance is currently unavailable. Wait a few minutes and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSerialConsoleSSHPublicKey
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSerialConsoleSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSerialConsoleSshPublicKeyResponse> sendSerialConsoleSSHPublicKey(
            SendSerialConsoleSshPublicKeyRequest sendSerialConsoleSshPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60
     * seconds to establish a serial console connection to the instance using SSH. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-serial-console.html">EC2 Serial Console</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendSerialConsoleSshPublicKeyRequest.Builder}
     * avoiding the need to create one manually via {@link SendSerialConsoleSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param sendSerialConsoleSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link SendSerialConsoleSSHPublicKeyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the SendSerialConsoleSSHPublicKey operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthException Either your AWS credentials are not valid or you do not have access to the EC2
     *         instance.</li>
     *         <li>SerialConsoleAccessDisabledException Your account is not authorized to use the EC2 Serial Console. To
     *         authorize your account, run the EnableSerialConsoleAccess API. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html"
     *         >EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.</li>
     *         <li>InvalidArgsException One of the parameters is not valid.</li>
     *         <li>ServiceException The service encountered an error. Follow the instructions in the error message and
     *         try again.</li>
     *         <li>ThrottlingException The requests were made too frequently and have been throttled. Wait a while and
     *         try again. To increase the limit on your request frequency, contact AWS Support.</li>
     *         <li>Ec2InstanceNotFoundException The specified instance was not found.</li>
     *         <li>Ec2InstanceTypeInvalidException The instance type is not supported for connecting via the serial
     *         console. Only Nitro instance types are currently supported.</li>
     *         <li>SerialConsoleSessionLimitExceededException The instance currently has 1 active serial console
     *         session. Only 1 session is supported at a time.</li>
     *         <li>SerialConsoleSessionUnavailableException Unable to start a serial console session. Please try again.</li>
     *         <li>Ec2InstanceStateInvalidException Unable to connect because the instance is not in a valid state.
     *         Connecting to a stopped or terminated instance is not supported. If the instance is stopped, start your
     *         instance, and try to connect again.</li>
     *         <li>Ec2InstanceUnavailableException The instance is currently unavailable. Wait a few minutes and try
     *         again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Ec2InstanceConnectException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample Ec2InstanceConnectAsyncClient.SendSerialConsoleSSHPublicKey
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSerialConsoleSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendSerialConsoleSshPublicKeyResponse> sendSerialConsoleSSHPublicKey(
            Consumer<SendSerialConsoleSshPublicKeyRequest.Builder> sendSerialConsoleSshPublicKeyRequest) {
        return sendSerialConsoleSSHPublicKey(SendSerialConsoleSshPublicKeyRequest.builder()
                .applyMutation(sendSerialConsoleSshPublicKeyRequest).build());
    }
}
