/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteImageResponse extends EcrResponse implements
        ToCopyableBuilder<BatchDeleteImageResponse.Builder, BatchDeleteImageResponse> {
    private static final SdkField<List<ImageIdentifier>> IMAGE_IDS_FIELD = SdkField
            .<List<ImageIdentifier>> builder(MarshallingType.LIST)
            .memberName("imageIds")
            .getter(getter(BatchDeleteImageResponse::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImageFailure>> FAILURES_FIELD = SdkField
            .<List<ImageFailure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchDeleteImageResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD,
            FAILURES_FIELD));

    private final List<ImageIdentifier> imageIds;

    private final List<ImageFailure> failures;

    private BatchDeleteImageResponse(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.failures = builder.failures;
    }

    /**
     * Returns true if the ImageIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image IDs of the deleted images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImageIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The image IDs of the deleted images.
     */
    public final List<ImageIdentifier> imageIds() {
        return imageIds;
    }

    /**
     * Returns true if the Failures property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<ImageFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImageIds() ? imageIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageResponse)) {
            return false;
        }
        BatchDeleteImageResponse other = (BatchDeleteImageResponse) obj;
        return hasImageIds() == other.hasImageIds() && Objects.equals(imageIds(), other.imageIds())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteImageResponse").add("ImageIds", hasImageIds() ? imageIds() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImageResponse, T> g) {
        return obj -> g.apply((BatchDeleteImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteImageResponse> {
        /**
         * <p>
         * The image IDs of the deleted images.
         * </p>
         * 
         * @param imageIds
         *        The image IDs of the deleted images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<ImageIdentifier> imageIds);

        /**
         * <p>
         * The image IDs of the deleted images.
         * </p>
         * 
         * @param imageIds
         *        The image IDs of the deleted images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(ImageIdentifier... imageIds);

        /**
         * <p>
         * The image IDs of the deleted images.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<ImageIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #imageIds(List<ImageIdentifier>)}.
         * 
         * @param imageIds
         *        a consumer that will call methods on {@link List<ImageIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageIds(List<ImageIdentifier>)
         */
        Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<ImageFailure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(ImageFailure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageFailure>.Builder} avoiding the need to
         * create one manually via {@link List<ImageFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageFailure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<ImageFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<ImageFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<ImageFailure>)
         */
        Builder failures(Consumer<ImageFailure.Builder>... failures);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();

        private List<ImageFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageResponse model) {
            super(model);
            imageIds(model.imageIds);
            failures(model.failures);
        }

        public final List<ImageIdentifier.Builder> getImageIds() {
            List<ImageIdentifier.Builder> result = ImageIdentifierListCopier.copyToBuilder(this.imageIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds) {
            imageIds(Stream.of(imageIds).map(c -> ImageIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        public final List<ImageFailure.Builder> getFailures() {
            List<ImageFailure.Builder> result = ImageFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ImageFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> ImageFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchDeleteImageResponse build() {
            return new BatchDeleteImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
