/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLifecyclePolicyPreviewResponse extends EcrResponse implements
        ToCopyableBuilder<GetLifecyclePolicyPreviewResponse.Builder, GetLifecyclePolicyPreviewResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(GetLifecyclePolicyPreviewResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(GetLifecyclePolicyPreviewResponse::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecyclePolicyText").getter(getter(GetLifecyclePolicyPreviewResponse::lifecyclePolicyText))
            .setter(setter(Builder::lifecyclePolicyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyText").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetLifecyclePolicyPreviewResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetLifecyclePolicyPreviewResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<LifecyclePolicyPreviewResult>> PREVIEW_RESULTS_FIELD = SdkField
            .<List<LifecyclePolicyPreviewResult>> builder(MarshallingType.LIST)
            .memberName("previewResults")
            .getter(getter(GetLifecyclePolicyPreviewResponse::previewResults))
            .setter(setter(Builder::previewResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyPreviewResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyPreviewResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LifecyclePolicyPreviewSummary> SUMMARY_FIELD = SdkField
            .<LifecyclePolicyPreviewSummary> builder(MarshallingType.SDK_POJO).memberName("summary")
            .getter(getter(GetLifecyclePolicyPreviewResponse::summary)).setter(setter(Builder::summary))
            .constructor(LifecyclePolicyPreviewSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, LIFECYCLE_POLICY_TEXT_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, PREVIEW_RESULTS_FIELD,
            SUMMARY_FIELD));

    private final String registryId;

    private final String repositoryName;

    private final String lifecyclePolicyText;

    private final String status;

    private final String nextToken;

    private final List<LifecyclePolicyPreviewResult> previewResults;

    private final LifecyclePolicyPreviewSummary summary;

    private GetLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.previewResults = builder.previewResults;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The repository name associated with the request.
     * </p>
     * 
     * @return The repository name associated with the request.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The JSON lifecycle policy text.
     * </p>
     * 
     * @return The JSON lifecycle policy text.
     */
    public final String lifecyclePolicyText() {
        return lifecyclePolicyText;
    }

    /**
     * <p>
     * The status of the lifecycle policy preview request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the lifecycle policy preview request.
     * @see LifecyclePolicyPreviewStatus
     */
    public final LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the lifecycle policy preview request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LifecyclePolicyPreviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the lifecycle policy preview request.
     * @see LifecyclePolicyPreviewStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code> request. When the
     * results of a <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code> request.
     *         When the results of a <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this
     *         value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PreviewResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPreviewResults() {
        return previewResults != null && !(previewResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the lifecycle policy preview request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPreviewResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The results of the lifecycle policy preview request.
     */
    public final List<LifecyclePolicyPreviewResult> previewResults() {
        return previewResults;
    }

    /**
     * <p>
     * The list of images that is returned as a result of the action.
     * </p>
     * 
     * @return The list of images that is returned as a result of the action.
     */
    public final LifecyclePolicyPreviewSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPreviewResults() ? previewResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyPreviewResponse)) {
            return false;
        }
        GetLifecyclePolicyPreviewResponse other = (GetLifecyclePolicyPreviewResponse) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(lifecyclePolicyText(), other.lifecyclePolicyText())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(nextToken(), other.nextToken())
                && hasPreviewResults() == other.hasPreviewResults() && Objects.equals(previewResults(), other.previewResults())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLifecyclePolicyPreviewResponse").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("LifecyclePolicyText", lifecyclePolicyText())
                .add("Status", statusAsString()).add("NextToken", nextToken())
                .add("PreviewResults", hasPreviewResults() ? previewResults() : null).add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "lifecyclePolicyText":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyText()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "previewResults":
            return Optional.ofNullable(clazz.cast(previewResults()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyPreviewResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLifecyclePolicyPreviewResponse> {
        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The repository name associated with the request.
         * </p>
         * 
         * @param repositoryName
         *        The repository name associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The JSON lifecycle policy text.
         * </p>
         * 
         * @param lifecyclePolicyText
         *        The JSON lifecycle policy text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyText(String lifecyclePolicyText);

        /**
         * <p>
         * The status of the lifecycle policy preview request.
         * </p>
         * 
         * @param status
         *        The status of the lifecycle policy preview request.
         * @see LifecyclePolicyPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyPreviewStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the lifecycle policy preview request.
         * </p>
         * 
         * @param status
         *        The status of the lifecycle policy preview request.
         * @see LifecyclePolicyPreviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyPreviewStatus
         */
        Builder status(LifecyclePolicyPreviewStatus status);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code> request. When
         * the results of a <code>GetLifecyclePolicyPreview</code> request exceed <code>maxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>GetLifecyclePolicyPreview</code>
         *        request. When the results of a <code>GetLifecyclePolicyPreview</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The results of the lifecycle policy preview request.
         * </p>
         * 
         * @param previewResults
         *        The results of the lifecycle policy preview request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previewResults(Collection<LifecyclePolicyPreviewResult> previewResults);

        /**
         * <p>
         * The results of the lifecycle policy preview request.
         * </p>
         * 
         * @param previewResults
         *        The results of the lifecycle policy preview request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previewResults(LifecyclePolicyPreviewResult... previewResults);

        /**
         * <p>
         * The results of the lifecycle policy preview request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LifecyclePolicyPreviewResult>.Builder}
         * avoiding the need to create one manually via {@link List<LifecyclePolicyPreviewResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecyclePolicyPreviewResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #previewResults(List<LifecyclePolicyPreviewResult>)}.
         * 
         * @param previewResults
         *        a consumer that will call methods on {@link List<LifecyclePolicyPreviewResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previewResults(List<LifecyclePolicyPreviewResult>)
         */
        Builder previewResults(Consumer<LifecyclePolicyPreviewResult.Builder>... previewResults);

        /**
         * <p>
         * The list of images that is returned as a result of the action.
         * </p>
         * 
         * @param summary
         *        The list of images that is returned as a result of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(LifecyclePolicyPreviewSummary summary);

        /**
         * <p>
         * The list of images that is returned as a result of the action.
         * </p>
         * This is a convenience that creates an instance of the {@link LifecyclePolicyPreviewSummary.Builder} avoiding
         * the need to create one manually via {@link LifecyclePolicyPreviewSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecyclePolicyPreviewSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(LifecyclePolicyPreviewSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link LifecyclePolicyPreviewSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(LifecyclePolicyPreviewSummary)
         */
        default Builder summary(Consumer<LifecyclePolicyPreviewSummary.Builder> summary) {
            return summary(LifecyclePolicyPreviewSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private String lifecyclePolicyText;

        private String status;

        private String nextToken;

        private List<LifecyclePolicyPreviewResult> previewResults = DefaultSdkAutoConstructList.getInstance();

        private LifecyclePolicyPreviewSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyPreviewResponse model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            lifecyclePolicyText(model.lifecyclePolicyText);
            status(model.status);
            nextToken(model.nextToken);
            previewResults(model.previewResults);
            summary(model.summary);
        }

        public final String getRegistryId() {
            return registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<LifecyclePolicyPreviewResult.Builder> getPreviewResults() {
            List<LifecyclePolicyPreviewResult.Builder> result = LifecyclePolicyPreviewResultListCopier
                    .copyToBuilder(this.previewResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder previewResults(Collection<LifecyclePolicyPreviewResult> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copy(previewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(LifecyclePolicyPreviewResult... previewResults) {
            previewResults(Arrays.asList(previewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(Consumer<LifecyclePolicyPreviewResult.Builder>... previewResults) {
            previewResults(Stream.of(previewResults).map(c -> LifecyclePolicyPreviewResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPreviewResults(Collection<LifecyclePolicyPreviewResult.BuilderImpl> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copyFromBuilder(previewResults);
        }

        public final LifecyclePolicyPreviewSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(LifecyclePolicyPreviewSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(LifecyclePolicyPreviewSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public GetLifecyclePolicyPreviewResponse build() {
            return new GetLifecyclePolicyPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
