/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing an Amazon ECR image layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Layer implements SdkPojo, Serializable, ToCopyableBuilder<Layer.Builder, Layer> {
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerDigest").getter(getter(Layer::layerDigest)).setter(setter(Builder::layerDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()).build();

    private static final SdkField<String> LAYER_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerAvailability").getter(getter(Layer::layerAvailabilityAsString))
            .setter(setter(Builder::layerAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerAvailability").build()).build();

    private static final SdkField<Long> LAYER_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("layerSize")
            .getter(getter(Layer::layerSize)).setter(setter(Builder::layerSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerSize").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mediaType").getter(getter(Layer::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_DIGEST_FIELD,
            LAYER_AVAILABILITY_FIELD, LAYER_SIZE_FIELD, MEDIA_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String layerDigest;

    private final String layerAvailability;

    private final Long layerSize;

    private final String mediaType;

    private Layer(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.layerAvailability = builder.layerAvailability;
        this.layerSize = builder.layerSize;
        this.mediaType = builder.mediaType;
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image layer.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image layer.
     */
    public final String layerDigest() {
        return layerDigest;
    }

    /**
     * <p>
     * The availability status of the image layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layerAvailability}
     * will return {@link LayerAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #layerAvailabilityAsString}.
     * </p>
     * 
     * @return The availability status of the image layer.
     * @see LayerAvailability
     */
    public final LayerAvailability layerAvailability() {
        return LayerAvailability.fromValue(layerAvailability);
    }

    /**
     * <p>
     * The availability status of the image layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layerAvailability}
     * will return {@link LayerAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #layerAvailabilityAsString}.
     * </p>
     * 
     * @return The availability status of the image layer.
     * @see LayerAvailability
     */
    public final String layerAvailabilityAsString() {
        return layerAvailability;
    }

    /**
     * <p>
     * The size, in bytes, of the image layer.
     * </p>
     * 
     * @return The size, in bytes, of the image layer.
     */
    public final Long layerSize() {
        return layerSize;
    }

    /**
     * <p>
     * The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
     * <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.
     * </p>
     * 
     * @return The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
     *         <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.
     */
    public final String mediaType() {
        return mediaType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerDigest());
        hashCode = 31 * hashCode + Objects.hashCode(layerAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(layerSize());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer) obj;
        return Objects.equals(layerDigest(), other.layerDigest())
                && Objects.equals(layerAvailabilityAsString(), other.layerAvailabilityAsString())
                && Objects.equals(layerSize(), other.layerSize()) && Objects.equals(mediaType(), other.mediaType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Layer").add("LayerDigest", layerDigest()).add("LayerAvailability", layerAvailabilityAsString())
                .add("LayerSize", layerSize()).add("MediaType", mediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "layerDigest":
            return Optional.ofNullable(clazz.cast(layerDigest()));
        case "layerAvailability":
            return Optional.ofNullable(clazz.cast(layerAvailabilityAsString()));
        case "layerSize":
            return Optional.ofNullable(clazz.cast(layerSize()));
        case "mediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Layer, T> g) {
        return obj -> g.apply((Layer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Layer> {
        /**
         * <p>
         * The <code>sha256</code> digest of the image layer.
         * </p>
         * 
         * @param layerDigest
         *        The <code>sha256</code> digest of the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDigest(String layerDigest);

        /**
         * <p>
         * The availability status of the image layer.
         * </p>
         * 
         * @param layerAvailability
         *        The availability status of the image layer.
         * @see LayerAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerAvailability
         */
        Builder layerAvailability(String layerAvailability);

        /**
         * <p>
         * The availability status of the image layer.
         * </p>
         * 
         * @param layerAvailability
         *        The availability status of the image layer.
         * @see LayerAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerAvailability
         */
        Builder layerAvailability(LayerAvailability layerAvailability);

        /**
         * <p>
         * The size, in bytes, of the image layer.
         * </p>
         * 
         * @param layerSize
         *        The size, in bytes, of the image layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerSize(Long layerSize);

        /**
         * <p>
         * The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
         * <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.
         * </p>
         * 
         * @param mediaType
         *        The media type of the layer, such as <code>application/vnd.docker.image.rootfs.diff.tar.gzip</code> or
         *        <code>application/vnd.oci.image.layer.v1.tar+gzip</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);
    }

    static final class BuilderImpl implements Builder {
        private String layerDigest;

        private String layerAvailability;

        private Long layerSize;

        private String mediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            layerDigest(model.layerDigest);
            layerAvailability(model.layerAvailability);
            layerSize(model.layerSize);
            mediaType(model.mediaType);
        }

        public final String getLayerDigest() {
            return layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public final String getLayerAvailability() {
            return layerAvailability;
        }

        @Override
        public final Builder layerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
            return this;
        }

        @Override
        public final Builder layerAvailability(LayerAvailability layerAvailability) {
            this.layerAvailability(layerAvailability == null ? null : layerAvailability.toString());
            return this;
        }

        public final void setLayerAvailability(String layerAvailability) {
            this.layerAvailability = layerAvailability;
        }

        public final Long getLayerSize() {
            return layerSize;
        }

        @Override
        public final Builder layerSize(Long layerSize) {
            this.layerSize = layerSize;
            return this;
        }

        public final void setLayerSize(Long layerSize) {
            this.layerSize = layerSize;
        }

        public final String getMediaType() {
            return mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public Layer build() {
            return new Layer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
