/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRegistryPolicyResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DeleteRegistryPolicyResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DeleteRegistryPolicyResponse.getter(DeleteRegistryPolicyResponse::registryId)).setter(DeleteRegistryPolicyResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyText").getter(DeleteRegistryPolicyResponse.getter(DeleteRegistryPolicyResponse::policyText)).setter(DeleteRegistryPolicyResponse.setter(Builder::policyText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, POLICY_TEXT_FIELD));
    private final String registryId;
    private final String policyText;

    private DeleteRegistryPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.policyText = builder.policyText;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String policyText() {
        return this.policyText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRegistryPolicyResponse)) {
            return false;
        }
        DeleteRegistryPolicyResponse other = (DeleteRegistryPolicyResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.policyText(), other.policyText());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRegistryPolicyResponse").add("RegistryId", (Object)this.registryId()).add("PolicyText", (Object)this.policyText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "policyText": {
                return Optional.ofNullable(clazz.cast(this.policyText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRegistryPolicyResponse, T> g) {
        return obj -> g.apply((DeleteRegistryPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String policyText;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRegistryPolicyResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.policyText(model.policyText);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getPolicyText() {
            return this.policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        @Override
        public DeleteRegistryPolicyResponse build() {
            return new DeleteRegistryPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRegistryPolicyResponse> {
        public Builder registryId(String var1);

        public Builder policyText(String var1);
    }
}

