/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of objects representing the replication destinations for a replication configuration. A replication
 * configuration may contain only one replication rule but the rule may contain one or more replication destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationRule implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationRule.Builder, ReplicationRule> {
    private static final SdkField<List<ReplicationDestination>> DESTINATIONS_FIELD = SdkField
            .<List<ReplicationDestination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(ReplicationRule::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReplicationDestination> destinations;

    private ReplicationRule(BuilderImpl builder) {
        this.destinations = builder.destinations;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the details of a replication destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects representing the details of a replication destination.
     */
    public final List<ReplicationDestination> destinations() {
        return destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationRule").add("Destinations", hasDestinations() ? destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationRule, T> g) {
        return obj -> g.apply((ReplicationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationRule> {
        /**
         * <p>
         * An array of objects representing the details of a replication destination.
         * </p>
         * 
         * @param destinations
         *        An array of objects representing the details of a replication destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<ReplicationDestination> destinations);

        /**
         * <p>
         * An array of objects representing the details of a replication destination.
         * </p>
         * 
         * @param destinations
         *        An array of objects representing the details of a replication destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(ReplicationDestination... destinations);

        /**
         * <p>
         * An array of objects representing the details of a replication destination.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicationDestination>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicationDestination>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationDestination>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<ReplicationDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<ReplicationDestination>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<ReplicationDestination>)
         */
        Builder destinations(Consumer<ReplicationDestination.Builder>... destinations);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplicationDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationRule model) {
            destinations(model.destinations);
        }

        public final List<ReplicationDestination.Builder> getDestinations() {
            List<ReplicationDestination.Builder> result = ReplicationDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder destinations(Collection<ReplicationDestination> destinations) {
            this.destinations = ReplicationDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(ReplicationDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<ReplicationDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> ReplicationDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<ReplicationDestination.BuilderImpl> destinations) {
            this.destinations = ReplicationDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public ReplicationRule build() {
            return new ReplicationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
