/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The image details of the Amazon ECR container image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrContainerImageDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrContainerImageDetails.Builder, AwsEcrContainerImageDetails> {
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(AwsEcrContainerImageDetails::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("author")
            .getter(getter(AwsEcrContainerImageDetails::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<String> IMAGE_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageHash").getter(getter(AwsEcrContainerImageDetails::imageHash)).setter(setter(Builder::imageHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageHash").build()).build();

    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("imageTags")
            .getter(getter(AwsEcrContainerImageDetails::imageTags))
            .setter(setter(Builder::imageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(AwsEcrContainerImageDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<Instant> PUSHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pushedAt").getter(getter(AwsEcrContainerImageDetails::pushedAt)).setter(setter(Builder::pushedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pushedAt").build()).build();

    private static final SdkField<String> REGISTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registry").getter(getter(AwsEcrContainerImageDetails::registry)).setter(setter(Builder::registry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registry").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(AwsEcrContainerImageDetails::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            AUTHOR_FIELD, IMAGE_HASH_FIELD, IMAGE_TAGS_FIELD, PLATFORM_FIELD, PUSHED_AT_FIELD, REGISTRY_FIELD,
            REPOSITORY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String architecture;

    private final String author;

    private final String imageHash;

    private final List<String> imageTags;

    private final String platform;

    private final Instant pushedAt;

    private final String registry;

    private final String repositoryName;

    private AwsEcrContainerImageDetails(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.author = builder.author;
        this.imageHash = builder.imageHash;
        this.imageTags = builder.imageTags;
        this.platform = builder.platform;
        this.pushedAt = builder.pushedAt;
        this.registry = builder.registry;
        this.repositoryName = builder.repositoryName;
    }

    /**
     * <p>
     * The architecture of the Amazon ECR container image.
     * </p>
     * 
     * @return The architecture of the Amazon ECR container image.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The image author of the Amazon ECR container image.
     * </p>
     * 
     * @return The image author of the Amazon ECR container image.
     */
    public final String author() {
        return author;
    }

    /**
     * <p>
     * The image hash of the Amazon ECR container image.
     * </p>
     * 
     * @return The image hash of the Amazon ECR container image.
     */
    public final String imageHash() {
        return imageHash;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageTags() {
        return imageTags != null && !(imageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image tags attached to the Amazon ECR container image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTags} method.
     * </p>
     * 
     * @return The image tags attached to the Amazon ECR container image.
     */
    public final List<String> imageTags() {
        return imageTags;
    }

    /**
     * <p>
     * The platform of the Amazon ECR container image.
     * </p>
     * 
     * @return The platform of the Amazon ECR container image.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The date and time the Amazon ECR container image was pushed.
     * </p>
     * 
     * @return The date and time the Amazon ECR container image was pushed.
     */
    public final Instant pushedAt() {
        return pushedAt;
    }

    /**
     * <p>
     * The registry the Amazon ECR container image belongs to.
     * </p>
     * 
     * @return The registry the Amazon ECR container image belongs to.
     */
    public final String registry() {
        return registry;
    }

    /**
     * <p>
     * The name of the repository the Amazon ECR container image resides in.
     * </p>
     * 
     * @return The name of the repository the Amazon ECR container image resides in.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(imageHash());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTags() ? imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(pushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(registry());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerImageDetails)) {
            return false;
        }
        AwsEcrContainerImageDetails other = (AwsEcrContainerImageDetails) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(author(), other.author())
                && Objects.equals(imageHash(), other.imageHash()) && hasImageTags() == other.hasImageTags()
                && Objects.equals(imageTags(), other.imageTags()) && Objects.equals(platform(), other.platform())
                && Objects.equals(pushedAt(), other.pushedAt()) && Objects.equals(registry(), other.registry())
                && Objects.equals(repositoryName(), other.repositoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrContainerImageDetails").add("Architecture", architecture()).add("Author", author())
                .add("ImageHash", imageHash()).add("ImageTags", hasImageTags() ? imageTags() : null).add("Platform", platform())
                .add("PushedAt", pushedAt()).add("Registry", registry()).add("RepositoryName", repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "author":
            return Optional.ofNullable(clazz.cast(author()));
        case "imageHash":
            return Optional.ofNullable(clazz.cast(imageHash()));
        case "imageTags":
            return Optional.ofNullable(clazz.cast(imageTags()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "pushedAt":
            return Optional.ofNullable(clazz.cast(pushedAt()));
        case "registry":
            return Optional.ofNullable(clazz.cast(registry()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerImageDetails, T> g) {
        return obj -> g.apply((AwsEcrContainerImageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrContainerImageDetails> {
        /**
         * <p>
         * The architecture of the Amazon ECR container image.
         * </p>
         * 
         * @param architecture
         *        The architecture of the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The image author of the Amazon ECR container image.
         * </p>
         * 
         * @param author
         *        The image author of the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The image hash of the Amazon ECR container image.
         * </p>
         * 
         * @param imageHash
         *        The image hash of the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageHash(String imageHash);

        /**
         * <p>
         * The image tags attached to the Amazon ECR container image.
         * </p>
         * 
         * @param imageTags
         *        The image tags attached to the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(Collection<String> imageTags);

        /**
         * <p>
         * The image tags attached to the Amazon ECR container image.
         * </p>
         * 
         * @param imageTags
         *        The image tags attached to the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(String... imageTags);

        /**
         * <p>
         * The platform of the Amazon ECR container image.
         * </p>
         * 
         * @param platform
         *        The platform of the Amazon ECR container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The date and time the Amazon ECR container image was pushed.
         * </p>
         * 
         * @param pushedAt
         *        The date and time the Amazon ECR container image was pushed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pushedAt(Instant pushedAt);

        /**
         * <p>
         * The registry the Amazon ECR container image belongs to.
         * </p>
         * 
         * @param registry
         *        The registry the Amazon ECR container image belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registry(String registry);

        /**
         * <p>
         * The name of the repository the Amazon ECR container image resides in.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository the Amazon ECR container image resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);
    }

    static final class BuilderImpl implements Builder {
        private String architecture;

        private String author;

        private String imageHash;

        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();

        private String platform;

        private Instant pushedAt;

        private String registry;

        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerImageDetails model) {
            architecture(model.architecture);
            author(model.author);
            imageHash(model.imageHash);
            imageTags(model.imageTags);
            platform(model.platform);
            pushedAt(model.pushedAt);
            registry(model.registry);
            repositoryName(model.repositoryName);
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        @Transient
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final String getAuthor() {
            return author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        @Transient
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getImageHash() {
            return imageHash;
        }

        public final void setImageHash(String imageHash) {
            this.imageHash = imageHash;
        }

        @Override
        @Transient
        public final Builder imageHash(String imageHash) {
            this.imageHash = imageHash;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagsListCopier.copy(imageTags);
        }

        @Override
        @Transient
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagsListCopier.copy(imageTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageTags(String... imageTags) {
            imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final Instant getPushedAt() {
            return pushedAt;
        }

        public final void setPushedAt(Instant pushedAt) {
            this.pushedAt = pushedAt;
        }

        @Override
        @Transient
        public final Builder pushedAt(Instant pushedAt) {
            this.pushedAt = pushedAt;
            return this;
        }

        public final String getRegistry() {
            return registry;
        }

        public final void setRegistry(String registry) {
            this.registry = registry;
        }

        @Override
        @Transient
        public final Builder registry(String registry) {
            this.registry = registry;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @Override
        public AwsEcrContainerImageDetails build() {
            return new AwsEcrContainerImageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
