/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetImageResponse extends EcrResponse implements
        ToCopyableBuilder<BatchGetImageResponse.Builder, BatchGetImageResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField
            .<List<Image>> builder(MarshallingType.LIST)
            .memberName("images")
            .getter(getter(BatchGetImageResponse::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Image> builder(MarshallingType.SDK_POJO)
                                            .constructor(Image::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImageFailure>> FAILURES_FIELD = SdkField
            .<List<ImageFailure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchGetImageResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD, FAILURES_FIELD));

    private final List<Image> images;

    private final List<ImageFailure> failures;

    private BatchGetImageResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the Images property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of image objects corresponding to the image references in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImages} method.
     * </p>
     * 
     * @return A list of image objects corresponding to the image references in the request.
     */
    public final List<Image> images() {
        return images;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<ImageFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageResponse)) {
            return false;
        }
        BatchGetImageResponse other = (BatchGetImageResponse) obj;
        return hasImages() == other.hasImages() && Objects.equals(images(), other.images())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetImageResponse").add("Images", hasImages() ? images() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "images":
            return Optional.ofNullable(clazz.cast(images()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetImageResponse, T> g) {
        return obj -> g.apply((BatchGetImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetImageResponse> {
        /**
         * <p>
         * A list of image objects corresponding to the image references in the request.
         * </p>
         * 
         * @param images
         *        A list of image objects corresponding to the image references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<Image> images);

        /**
         * <p>
         * A list of image objects corresponding to the image references in the request.
         * </p>
         * 
         * @param images
         *        A list of image objects corresponding to the image references in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Image... images);

        /**
         * <p>
         * A list of image objects corresponding to the image references in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Image>.Builder} avoiding the need to create
         * one manually via {@link List<Image>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Image>.Builder#build()} is called immediately and its result
         * is passed to {@link #images(List<Image>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<Image>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<Image>)
         */
        Builder images(Consumer<Image.Builder>... images);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<ImageFailure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(ImageFailure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageFailure>.Builder} avoiding the need to
         * create one manually via {@link List<ImageFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageFailure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<ImageFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<ImageFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<ImageFailure>)
         */
        Builder failures(Consumer<ImageFailure.Builder>... failures);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();

        private List<ImageFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageResponse model) {
            super(model);
            images(model.images);
            failures(model.failures);
        }

        public final List<Image.Builder> getImages() {
            List<Image.Builder> result = ImageListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        @Override
        @Transient
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder images(Image... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder>... images) {
            images(Stream.of(images).map(c -> Image.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImageFailure.Builder> getFailures() {
            List<ImageFailure.Builder> result = ImageFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        @Transient
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failures(ImageFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failures(Consumer<ImageFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> ImageFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetImageResponse build() {
            return new BatchGetImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
