/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePullThroughCacheRuleRequest extends EcrRequest implements
        ToCopyableBuilder<CreatePullThroughCacheRuleRequest.Builder, CreatePullThroughCacheRuleRequest> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(CreatePullThroughCacheRuleRequest::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(CreatePullThroughCacheRuleRequest::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CreatePullThroughCacheRuleRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            UPSTREAM_REGISTRY_URL_FIELD, REGISTRY_ID_FIELD));

    private final String ecrRepositoryPrefix;

    private final String upstreamRegistryUrl;

    private final String registryId;

    private CreatePullThroughCacheRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.registryId = builder.registryId;
    }

    /**
     * <p>
     * The repository name prefix to use when caching images from the source registry.
     * </p>
     * 
     * @return The repository name prefix to use when caching images from the source registry.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The registry URL of the upstream public registry to use as the source for the pull through cache rule.
     * </p>
     * 
     * @return The registry URL of the upstream public registry to use as the source for the pull through cache rule.
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you
     * do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry to create the pull through cache rule
     *         for. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullThroughCacheRuleRequest)) {
            return false;
        }
        CreatePullThroughCacheRuleRequest other = (CreatePullThroughCacheRuleRequest) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(registryId(), other.registryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePullThroughCacheRuleRequest").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("UpstreamRegistryUrl", upstreamRegistryUrl()).add("RegistryId", registryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePullThroughCacheRuleRequest, T> g) {
        return obj -> g.apply((CreatePullThroughCacheRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePullThroughCacheRuleRequest> {
        /**
         * <p>
         * The repository name prefix to use when caching images from the source registry.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The repository name prefix to use when caching images from the source registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The registry URL of the upstream public registry to use as the source for the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistryUrl
         *        The registry URL of the upstream public registry to use as the source for the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If
         * you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry to create the pull through cache rule
         *        for. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String upstreamRegistryUrl;

        private String registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullThroughCacheRuleRequest model) {
            super(model);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            registryId(model.registryId);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        @Transient
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        @Transient
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullThroughCacheRuleRequest build() {
            return new CreatePullThroughCacheRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
