/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePullThroughCacheRulesRequest extends EcrRequest implements
        ToCopyableBuilder<DescribePullThroughCacheRulesRequest.Builder, DescribePullThroughCacheRulesRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(DescribePullThroughCacheRulesRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<List<String>> ECR_REPOSITORY_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ecrRepositoryPrefixes")
            .getter(getter(DescribePullThroughCacheRulesRequest::ecrRepositoryPrefixes))
            .setter(setter(Builder::ecrRepositoryPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribePullThroughCacheRulesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribePullThroughCacheRulesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            ECR_REPOSITORY_PREFIXES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String registryId;

    private final List<String> ecrRepositoryPrefixes;

    private final String nextToken;

    private final Integer maxResults;

    private DescribePullThroughCacheRulesRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.ecrRepositoryPrefixes = builder.ecrRepositoryPrefixes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry to return the pull through cache rules for. If
     * you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry to return the pull through cache rules
     *         for. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrRepositoryPrefixes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEcrRepositoryPrefixes() {
        return ecrRepositoryPrefixes != null && !(ecrRepositoryPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository
     * prefix value is specified, all pull through cache rules are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrRepositoryPrefixes} method.
     * </p>
     * 
     * @return The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no
     *         repository prefix value is specified, all pull through cache rules are returned.
     */
    public final List<String> ecrRepositoryPrefixes() {
        return ecrRepositoryPrefixes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated
     * <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the
     * <code>nextToken</code> value. This value is null when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the
     *         results exceeded the value of that parameter. Pagination continues from the end of the previous results
     *         that returned the <code>nextToken</code> value. This value is null when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code> in
     * paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only returns
     * <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The
     * remaining results of the initial request can be seen by sending another
     * <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value. This
     * value can be between 1 and 1000. If this parameter is not used, then
     * <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code> value,
     * if applicable.
     * </p>
     * 
     * @return The maximum number of pull through cache rules returned by
     *         <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used,
     *         <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with the
     *         returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is not
     *         used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a
     *         <code>nextToken</code> value, if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrRepositoryPrefixes() ? ecrRepositoryPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullThroughCacheRulesRequest)) {
            return false;
        }
        DescribePullThroughCacheRulesRequest other = (DescribePullThroughCacheRulesRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && hasEcrRepositoryPrefixes() == other.hasEcrRepositoryPrefixes()
                && Objects.equals(ecrRepositoryPrefixes(), other.ecrRepositoryPrefixes())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePullThroughCacheRulesRequest").add("RegistryId", registryId())
                .add("EcrRepositoryPrefixes", hasEcrRepositoryPrefixes() ? ecrRepositoryPrefixes() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "ecrRepositoryPrefixes":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefixes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePullThroughCacheRulesRequest, T> g) {
        return obj -> g.apply((DescribePullThroughCacheRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePullThroughCacheRulesRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry to return the pull through cache rules for.
         * If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry to return the pull through cache rules
         *        for. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository
         * prefix value is specified, all pull through cache rules are returned.
         * </p>
         * 
         * @param ecrRepositoryPrefixes
         *        The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no
         *        repository prefix value is specified, all pull through cache rules are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefixes(Collection<String> ecrRepositoryPrefixes);

        /**
         * <p>
         * The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no repository
         * prefix value is specified, all pull through cache rules are returned.
         * </p>
         * 
         * @param ecrRepositoryPrefixes
         *        The Amazon ECR repository prefixes associated with the pull through cache rules to return. If no
         *        repository prefix value is specified, all pull through cache rules are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefixes(String... ecrRepositoryPrefixes);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated
         * <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and the
         * results exceeded the value of that parameter. Pagination continues from the end of the previous results that
         * returned the <code>nextToken</code> value. This value is null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribePullThroughCacheRulesRequest</code> request where <code>maxResults</code> was used and
         *        the results exceeded the value of that parameter. Pagination continues from the end of the previous
         *        results that returned the <code>nextToken</code> value. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of pull through cache rules returned by <code>DescribePullThroughCacheRulesRequest</code>
         * in paginated output. When this parameter is used, <code>DescribePullThroughCacheRulesRequest</code> only
         * returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response
         * element. The remaining results of the initial request can be seen by sending another
         * <code>DescribePullThroughCacheRulesRequest</code> request with the returned <code>nextToken</code> value.
         * This value can be between 1 and 1000. If this parameter is not used, then
         * <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a <code>nextToken</code>
         * value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of pull through cache rules returned by
         *        <code>DescribePullThroughCacheRulesRequest</code> in paginated output. When this parameter is used,
         *        <code>DescribePullThroughCacheRulesRequest</code> only returns <code>maxResults</code> results in a
         *        single page along with a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>DescribePullThroughCacheRulesRequest</code> request with
         *        the returned <code>nextToken</code> value. This value can be between 1 and 1000. If this parameter is
         *        not used, then <code>DescribePullThroughCacheRulesRequest</code> returns up to 100 results and a
         *        <code>nextToken</code> value, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private List<String> ecrRepositoryPrefixes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullThroughCacheRulesRequest model) {
            super(model);
            registryId(model.registryId);
            ecrRepositoryPrefixes(model.ecrRepositoryPrefixes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final Collection<String> getEcrRepositoryPrefixes() {
            if (ecrRepositoryPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return ecrRepositoryPrefixes;
        }

        public final void setEcrRepositoryPrefixes(Collection<String> ecrRepositoryPrefixes) {
            this.ecrRepositoryPrefixes = PullThroughCacheRuleRepositoryPrefixListCopier.copy(ecrRepositoryPrefixes);
        }

        @Override
        @Transient
        public final Builder ecrRepositoryPrefixes(Collection<String> ecrRepositoryPrefixes) {
            this.ecrRepositoryPrefixes = PullThroughCacheRuleRepositoryPrefixListCopier.copy(ecrRepositoryPrefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ecrRepositoryPrefixes(String... ecrRepositoryPrefixes) {
            ecrRepositoryPrefixes(Arrays.asList(ecrRepositoryPrefixes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePullThroughCacheRulesRequest build() {
            return new DescribePullThroughCacheRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
