/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegistryScanningConfigurationResponse extends EcrResponse implements
        ToCopyableBuilder<GetRegistryScanningConfigurationResponse.Builder, GetRegistryScanningConfigurationResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(GetRegistryScanningConfigurationResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<RegistryScanningConfiguration> SCANNING_CONFIGURATION_FIELD = SdkField
            .<RegistryScanningConfiguration> builder(MarshallingType.SDK_POJO).memberName("scanningConfiguration")
            .getter(getter(GetRegistryScanningConfigurationResponse::scanningConfiguration))
            .setter(setter(Builder::scanningConfiguration)).constructor(RegistryScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanningConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            SCANNING_CONFIGURATION_FIELD));

    private final String registryId;

    private final RegistryScanningConfiguration scanningConfiguration;

    private GetRegistryScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.scanningConfiguration = builder.scanningConfiguration;
    }

    /**
     * <p>
     * The ID of the registry.
     * </p>
     * 
     * @return The ID of the registry.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The scanning configuration for the registry.
     * </p>
     * 
     * @return The scanning configuration for the registry.
     */
    public final RegistryScanningConfiguration scanningConfiguration() {
        return scanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(scanningConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegistryScanningConfigurationResponse)) {
            return false;
        }
        GetRegistryScanningConfigurationResponse other = (GetRegistryScanningConfigurationResponse) obj;
        return Objects.equals(registryId(), other.registryId())
                && Objects.equals(scanningConfiguration(), other.scanningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegistryScanningConfigurationResponse").add("RegistryId", registryId())
                .add("ScanningConfiguration", scanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "scanningConfiguration":
            return Optional.ofNullable(clazz.cast(scanningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRegistryScanningConfigurationResponse, T> g) {
        return obj -> g.apply((GetRegistryScanningConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRegistryScanningConfigurationResponse> {
        /**
         * <p>
         * The ID of the registry.
         * </p>
         * 
         * @param registryId
         *        The ID of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The scanning configuration for the registry.
         * </p>
         * 
         * @param scanningConfiguration
         *        The scanning configuration for the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanningConfiguration(RegistryScanningConfiguration scanningConfiguration);

        /**
         * <p>
         * The scanning configuration for the registry.
         * </p>
         * This is a convenience that creates an instance of the {@link RegistryScanningConfiguration.Builder} avoiding
         * the need to create one manually via {@link RegistryScanningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryScanningConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scanningConfiguration(RegistryScanningConfiguration)}.
         * 
         * @param scanningConfiguration
         *        a consumer that will call methods on {@link RegistryScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanningConfiguration(RegistryScanningConfiguration)
         */
        default Builder scanningConfiguration(Consumer<RegistryScanningConfiguration.Builder> scanningConfiguration) {
            return scanningConfiguration(RegistryScanningConfiguration.builder().applyMutation(scanningConfiguration).build());
        }
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String registryId;

        private RegistryScanningConfiguration scanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegistryScanningConfigurationResponse model) {
            super(model);
            registryId(model.registryId);
            scanningConfiguration(model.scanningConfiguration);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final RegistryScanningConfiguration.Builder getScanningConfiguration() {
            return scanningConfiguration != null ? scanningConfiguration.toBuilder() : null;
        }

        public final void setScanningConfiguration(RegistryScanningConfiguration.BuilderImpl scanningConfiguration) {
            this.scanningConfiguration = scanningConfiguration != null ? scanningConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder scanningConfiguration(RegistryScanningConfiguration scanningConfiguration) {
            this.scanningConfiguration = scanningConfiguration;
            return this;
        }

        @Override
        public GetRegistryScanningConfigurationResponse build() {
            return new GetRegistryScanningConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
