/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon Inspector score given to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScoreDetails implements SdkPojo, Serializable, ToCopyableBuilder<ScoreDetails.Builder, ScoreDetails> {
    private static final SdkField<CvssScoreDetails> CVSS_FIELD = SdkField.<CvssScoreDetails> builder(MarshallingType.SDK_POJO)
            .memberName("cvss").getter(getter(ScoreDetails::cvss)).setter(setter(Builder::cvss))
            .constructor(CvssScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CVSS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CvssScoreDetails cvss;

    private ScoreDetails(BuilderImpl builder) {
        this.cvss = builder.cvss;
    }

    /**
     * <p>
     * An object that contains details about the CVSS score given to a finding.
     * </p>
     * 
     * @return An object that contains details about the CVSS score given to a finding.
     */
    public final CvssScoreDetails cvss() {
        return cvss;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cvss());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScoreDetails)) {
            return false;
        }
        ScoreDetails other = (ScoreDetails) obj;
        return Objects.equals(cvss(), other.cvss());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScoreDetails").add("Cvss", cvss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cvss":
            return Optional.ofNullable(clazz.cast(cvss()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScoreDetails, T> g) {
        return obj -> g.apply((ScoreDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScoreDetails> {
        /**
         * <p>
         * An object that contains details about the CVSS score given to a finding.
         * </p>
         * 
         * @param cvss
         *        An object that contains details about the CVSS score given to a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(CvssScoreDetails cvss);

        /**
         * <p>
         * An object that contains details about the CVSS score given to a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link CvssScoreDetails.Builder} avoiding the need to
         * create one manually via {@link CvssScoreDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link CvssScoreDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #cvss(CvssScoreDetails)}.
         * 
         * @param cvss
         *        a consumer that will call methods on {@link CvssScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cvss(CvssScoreDetails)
         */
        default Builder cvss(Consumer<CvssScoreDetails.Builder> cvss) {
            return cvss(CvssScoreDetails.builder().applyMutation(cvss).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CvssScoreDetails cvss;

        private BuilderImpl() {
        }

        private BuilderImpl(ScoreDetails model) {
            cvss(model.cvss);
        }

        public final CvssScoreDetails.Builder getCvss() {
            return cvss != null ? cvss.toBuilder() : null;
        }

        public final void setCvss(CvssScoreDetails.BuilderImpl cvss) {
            this.cvss = cvss != null ? cvss.build() : null;
        }

        @Override
        @Transient
        public final Builder cvss(CvssScoreDetails cvss) {
            this.cvss = cvss;
            return this;
        }

        @Override
        public ScoreDetails build() {
            return new ScoreDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
