/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRepositoryScanningConfigurationResponse extends EcrResponse
        implements
        ToCopyableBuilder<BatchGetRepositoryScanningConfigurationResponse.Builder, BatchGetRepositoryScanningConfigurationResponse> {
    private static final SdkField<List<RepositoryScanningConfiguration>> SCANNING_CONFIGURATIONS_FIELD = SdkField
            .<List<RepositoryScanningConfiguration>> builder(MarshallingType.LIST)
            .memberName("scanningConfigurations")
            .getter(getter(BatchGetRepositoryScanningConfigurationResponse::scanningConfigurations))
            .setter(setter(Builder::scanningConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanningConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryScanningConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryScanningConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RepositoryScanningConfigurationFailure>> FAILURES_FIELD = SdkField
            .<List<RepositoryScanningConfigurationFailure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchGetRepositoryScanningConfigurationResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RepositoryScanningConfigurationFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(RepositoryScanningConfigurationFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNING_CONFIGURATIONS_FIELD,
            FAILURES_FIELD));

    private final List<RepositoryScanningConfiguration> scanningConfigurations;

    private final List<RepositoryScanningConfigurationFailure> failures;

    private BatchGetRepositoryScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.scanningConfigurations = builder.scanningConfigurations;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanningConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasScanningConfigurations() {
        return scanningConfigurations != null && !(scanningConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scanning configuration for the requested repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanningConfigurations} method.
     * </p>
     * 
     * @return The scanning configuration for the requested repositories.
     */
    public final List<RepositoryScanningConfiguration> scanningConfigurations() {
        return scanningConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<RepositoryScanningConfigurationFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScanningConfigurations() ? scanningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoryScanningConfigurationResponse)) {
            return false;
        }
        BatchGetRepositoryScanningConfigurationResponse other = (BatchGetRepositoryScanningConfigurationResponse) obj;
        return hasScanningConfigurations() == other.hasScanningConfigurations()
                && Objects.equals(scanningConfigurations(), other.scanningConfigurations())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRepositoryScanningConfigurationResponse")
                .add("ScanningConfigurations", hasScanningConfigurations() ? scanningConfigurations() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanningConfigurations":
            return Optional.ofNullable(clazz.cast(scanningConfigurations()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoryScanningConfigurationResponse, T> g) {
        return obj -> g.apply((BatchGetRepositoryScanningConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetRepositoryScanningConfigurationResponse> {
        /**
         * <p>
         * The scanning configuration for the requested repositories.
         * </p>
         * 
         * @param scanningConfigurations
         *        The scanning configuration for the requested repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanningConfigurations(Collection<RepositoryScanningConfiguration> scanningConfigurations);

        /**
         * <p>
         * The scanning configuration for the requested repositories.
         * </p>
         * 
         * @param scanningConfigurations
         *        The scanning configuration for the requested repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanningConfigurations(RepositoryScanningConfiguration... scanningConfigurations);

        /**
         * <p>
         * The scanning configuration for the requested repositories.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <RepositoryScanningConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <RepositoryScanningConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryScanningConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #scanningConfigurations(List<RepositoryScanningConfiguration>)}.
         * 
         * @param scanningConfigurations
         *        a consumer that will call methods on {@link List<RepositoryScanningConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanningConfigurations(List<RepositoryScanningConfiguration>)
         */
        Builder scanningConfigurations(Consumer<RepositoryScanningConfiguration.Builder>... scanningConfigurations);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<RepositoryScanningConfigurationFailure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(RepositoryScanningConfigurationFailure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <RepositoryScanningConfigurationFailure>.Builder} avoiding the need to create one manually via {@link List
         * <RepositoryScanningConfigurationFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RepositoryScanningConfigurationFailure>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #failures(List<RepositoryScanningConfigurationFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<RepositoryScanningConfigurationFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<RepositoryScanningConfigurationFailure>)
         */
        Builder failures(Consumer<RepositoryScanningConfigurationFailure.Builder>... failures);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<RepositoryScanningConfiguration> scanningConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<RepositoryScanningConfigurationFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoryScanningConfigurationResponse model) {
            super(model);
            scanningConfigurations(model.scanningConfigurations);
            failures(model.failures);
        }

        public final List<RepositoryScanningConfiguration.Builder> getScanningConfigurations() {
            List<RepositoryScanningConfiguration.Builder> result = RepositoryScanningConfigurationListCopier
                    .copyToBuilder(this.scanningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanningConfigurations(Collection<RepositoryScanningConfiguration.BuilderImpl> scanningConfigurations) {
            this.scanningConfigurations = RepositoryScanningConfigurationListCopier.copyFromBuilder(scanningConfigurations);
        }

        @Override
        public final Builder scanningConfigurations(Collection<RepositoryScanningConfiguration> scanningConfigurations) {
            this.scanningConfigurations = RepositoryScanningConfigurationListCopier.copy(scanningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanningConfigurations(RepositoryScanningConfiguration... scanningConfigurations) {
            scanningConfigurations(Arrays.asList(scanningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanningConfigurations(Consumer<RepositoryScanningConfiguration.Builder>... scanningConfigurations) {
            scanningConfigurations(Stream.of(scanningConfigurations)
                    .map(c -> RepositoryScanningConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryScanningConfigurationFailure.Builder> getFailures() {
            List<RepositoryScanningConfigurationFailure.Builder> result = RepositoryScanningConfigurationFailureListCopier
                    .copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<RepositoryScanningConfigurationFailure.BuilderImpl> failures) {
            this.failures = RepositoryScanningConfigurationFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<RepositoryScanningConfigurationFailure> failures) {
            this.failures = RepositoryScanningConfigurationFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(RepositoryScanningConfigurationFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<RepositoryScanningConfigurationFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> RepositoryScanningConfigurationFailure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRepositoryScanningConfigurationResponse build() {
            return new BatchGetRepositoryScanningConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
