/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePullThroughCacheRulesResponse extends EcrResponse implements
        ToCopyableBuilder<DescribePullThroughCacheRulesResponse.Builder, DescribePullThroughCacheRulesResponse> {
    private static final SdkField<List<PullThroughCacheRule>> PULL_THROUGH_CACHE_RULES_FIELD = SdkField
            .<List<PullThroughCacheRule>> builder(MarshallingType.LIST)
            .memberName("pullThroughCacheRules")
            .getter(getter(DescribePullThroughCacheRulesResponse::pullThroughCacheRules))
            .setter(setter(Builder::pullThroughCacheRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullThroughCacheRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PullThroughCacheRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PullThroughCacheRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribePullThroughCacheRulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PULL_THROUGH_CACHE_RULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<PullThroughCacheRule> pullThroughCacheRules;

    private final String nextToken;

    private DescribePullThroughCacheRulesResponse(BuilderImpl builder) {
        super(builder);
        this.pullThroughCacheRules = builder.pullThroughCacheRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PullThroughCacheRules property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPullThroughCacheRules() {
        return pullThroughCacheRules != null && !(pullThroughCacheRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the pull through cache rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPullThroughCacheRules} method.
     * </p>
     * 
     * @return The details of the pull through cache rules.
     */
    public final List<PullThroughCacheRule> pullThroughCacheRules() {
        return pullThroughCacheRules;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
     * there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
     *         request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
     *         <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null
     *         when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPullThroughCacheRules() ? pullThroughCacheRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullThroughCacheRulesResponse)) {
            return false;
        }
        DescribePullThroughCacheRulesResponse other = (DescribePullThroughCacheRulesResponse) obj;
        return hasPullThroughCacheRules() == other.hasPullThroughCacheRules()
                && Objects.equals(pullThroughCacheRules(), other.pullThroughCacheRules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePullThroughCacheRulesResponse")
                .add("PullThroughCacheRules", hasPullThroughCacheRules() ? pullThroughCacheRules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullThroughCacheRules":
            return Optional.ofNullable(clazz.cast(pullThroughCacheRules()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePullThroughCacheRulesResponse, T> g) {
        return obj -> g.apply((DescribePullThroughCacheRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePullThroughCacheRulesResponse> {
        /**
         * <p>
         * The details of the pull through cache rules.
         * </p>
         * 
         * @param pullThroughCacheRules
         *        The details of the pull through cache rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullThroughCacheRules(Collection<PullThroughCacheRule> pullThroughCacheRules);

        /**
         * <p>
         * The details of the pull through cache rules.
         * </p>
         * 
         * @param pullThroughCacheRules
         *        The details of the pull through cache rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullThroughCacheRules(PullThroughCacheRule... pullThroughCacheRules);

        /**
         * <p>
         * The details of the pull through cache rules.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PullThroughCacheRule>.Builder}
         * avoiding the need to create one manually via {@link List<PullThroughCacheRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PullThroughCacheRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #pullThroughCacheRules(List<PullThroughCacheRule>)}.
         * 
         * @param pullThroughCacheRules
         *        a consumer that will call methods on {@link List<PullThroughCacheRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pullThroughCacheRules(List<PullThroughCacheRule>)
         */
        Builder pullThroughCacheRules(Consumer<PullThroughCacheRule.Builder>... pullThroughCacheRules);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribePullThroughCacheRulesRequest</code>
         * request. When the results of a <code>DescribePullThroughCacheRulesRequest</code> request exceed
         * <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when
         * there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future
         *        <code>DescribePullThroughCacheRulesRequest</code> request. When the results of a
         *        <code>DescribePullThroughCacheRulesRequest</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is null when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<PullThroughCacheRule> pullThroughCacheRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullThroughCacheRulesResponse model) {
            super(model);
            pullThroughCacheRules(model.pullThroughCacheRules);
            nextToken(model.nextToken);
        }

        public final List<PullThroughCacheRule.Builder> getPullThroughCacheRules() {
            List<PullThroughCacheRule.Builder> result = PullThroughCacheRuleListCopier.copyToBuilder(this.pullThroughCacheRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPullThroughCacheRules(Collection<PullThroughCacheRule.BuilderImpl> pullThroughCacheRules) {
            this.pullThroughCacheRules = PullThroughCacheRuleListCopier.copyFromBuilder(pullThroughCacheRules);
        }

        @Override
        public final Builder pullThroughCacheRules(Collection<PullThroughCacheRule> pullThroughCacheRules) {
            this.pullThroughCacheRules = PullThroughCacheRuleListCopier.copy(pullThroughCacheRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullThroughCacheRules(PullThroughCacheRule... pullThroughCacheRules) {
            pullThroughCacheRules(Arrays.asList(pullThroughCacheRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullThroughCacheRules(Consumer<PullThroughCacheRule.Builder>... pullThroughCacheRules) {
            pullThroughCacheRules(Stream.of(pullThroughCacheRules)
                    .map(c -> PullThroughCacheRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePullThroughCacheRulesResponse build() {
            return new DescribePullThroughCacheRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
