/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an enhanced image scan. This is returned when enhanced scanning is enabled for your private registry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnhancedImageScanFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<EnhancedImageScanFinding.Builder, EnhancedImageScanFinding> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(EnhancedImageScanFinding::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnhancedImageScanFinding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FINDING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingArn").getter(getter(EnhancedImageScanFinding::findingArn)).setter(setter(Builder::findingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingArn").build()).build();

    private static final SdkField<Instant> FIRST_OBSERVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstObservedAt").getter(getter(EnhancedImageScanFinding::firstObservedAt))
            .setter(setter(Builder::firstObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstObservedAt").build()).build();

    private static final SdkField<Instant> LAST_OBSERVED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastObservedAt").getter(getter(EnhancedImageScanFinding::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastObservedAt").build()).build();

    private static final SdkField<PackageVulnerabilityDetails> PACKAGE_VULNERABILITY_DETAILS_FIELD = SdkField
            .<PackageVulnerabilityDetails> builder(MarshallingType.SDK_POJO)
            .memberName("packageVulnerabilityDetails")
            .getter(getter(EnhancedImageScanFinding::packageVulnerabilityDetails))
            .setter(setter(Builder::packageVulnerabilityDetails))
            .constructor(PackageVulnerabilityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVulnerabilityDetails")
                    .build()).build();

    private static final SdkField<Remediation> REMEDIATION_FIELD = SdkField.<Remediation> builder(MarshallingType.SDK_POJO)
            .memberName("remediation").getter(getter(EnhancedImageScanFinding::remediation)).setter(setter(Builder::remediation))
            .constructor(Remediation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(EnhancedImageScanFinding::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("score")
            .getter(getter(EnhancedImageScanFinding::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()).build();

    private static final SdkField<ScoreDetails> SCORE_DETAILS_FIELD = SdkField.<ScoreDetails> builder(MarshallingType.SDK_POJO)
            .memberName("scoreDetails").getter(getter(EnhancedImageScanFinding::scoreDetails))
            .setter(setter(Builder::scoreDetails)).constructor(ScoreDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreDetails").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(EnhancedImageScanFinding::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnhancedImageScanFinding::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(EnhancedImageScanFinding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(EnhancedImageScanFinding::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(EnhancedImageScanFinding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DESCRIPTION_FIELD, FINDING_ARN_FIELD, FIRST_OBSERVED_AT_FIELD, LAST_OBSERVED_AT_FIELD,
            PACKAGE_VULNERABILITY_DETAILS_FIELD, REMEDIATION_FIELD, RESOURCES_FIELD, SCORE_FIELD, SCORE_DETAILS_FIELD,
            SEVERITY_FIELD, STATUS_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String description;

    private final String findingArn;

    private final Instant firstObservedAt;

    private final Instant lastObservedAt;

    private final PackageVulnerabilityDetails packageVulnerabilityDetails;

    private final Remediation remediation;

    private final List<Resource> resources;

    private final Double score;

    private final ScoreDetails scoreDetails;

    private final String severity;

    private final String status;

    private final String title;

    private final String type;

    private final Instant updatedAt;

    private EnhancedImageScanFinding(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.description = builder.description;
        this.findingArn = builder.findingArn;
        this.firstObservedAt = builder.firstObservedAt;
        this.lastObservedAt = builder.lastObservedAt;
        this.packageVulnerabilityDetails = builder.packageVulnerabilityDetails;
        this.remediation = builder.remediation;
        this.resources = builder.resources;
        this.score = builder.score;
        this.scoreDetails = builder.scoreDetails;
        this.severity = builder.severity;
        this.status = builder.status;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the image.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the image.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the finding.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the finding.
     */
    public final String findingArn() {
        return findingArn;
    }

    /**
     * <p>
     * The date and time that the finding was first observed.
     * </p>
     * 
     * @return The date and time that the finding was first observed.
     */
    public final Instant firstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * The date and time that the finding was last observed.
     * </p>
     * 
     * @return The date and time that the finding was last observed.
     */
    public final Instant lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * An object that contains the details of a package vulnerability finding.
     * </p>
     * 
     * @return An object that contains the details of a package vulnerability finding.
     */
    public final PackageVulnerabilityDetails packageVulnerabilityDetails() {
        return packageVulnerabilityDetails;
    }

    /**
     * <p>
     * An object that contains the details about how to remediate a finding.
     * </p>
     * 
     * @return An object that contains the details about how to remediate a finding.
     */
    public final Remediation remediation() {
        return remediation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information on the resources involved in a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Contains information on the resources involved in a finding.
     */
    public final List<Resource> resources() {
        return resources;
    }

    /**
     * <p>
     * The Amazon Inspector score given to the finding.
     * </p>
     * 
     * @return The Amazon Inspector score given to the finding.
     */
    public final Double score() {
        return score;
    }

    /**
     * <p>
     * An object that contains details of the Amazon Inspector score.
     * </p>
     * 
     * @return An object that contains details of the Amazon Inspector score.
     */
    public final ScoreDetails scoreDetails() {
        return scoreDetails;
    }

    /**
     * <p>
     * The severity of the finding.
     * </p>
     * 
     * @return The severity of the finding.
     */
    public final String severity() {
        return severity;
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * 
     * @return The status of the finding.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The title of the finding.
     * </p>
     * 
     * @return The title of the finding.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The type of the finding.
     * </p>
     * 
     * @return The type of the finding.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The date and time the finding was last updated at.
     * </p>
     * 
     * @return The date and time the finding was last updated at.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(findingArn());
        hashCode = 31 * hashCode + Objects.hashCode(firstObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(packageVulnerabilityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(scoreDetails());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedImageScanFinding)) {
            return false;
        }
        EnhancedImageScanFinding other = (EnhancedImageScanFinding) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(description(), other.description())
                && Objects.equals(findingArn(), other.findingArn()) && Objects.equals(firstObservedAt(), other.firstObservedAt())
                && Objects.equals(lastObservedAt(), other.lastObservedAt())
                && Objects.equals(packageVulnerabilityDetails(), other.packageVulnerabilityDetails())
                && Objects.equals(remediation(), other.remediation()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources()) && Objects.equals(score(), other.score())
                && Objects.equals(scoreDetails(), other.scoreDetails()) && Objects.equals(severity(), other.severity())
                && Objects.equals(status(), other.status()) && Objects.equals(title(), other.title())
                && Objects.equals(type(), other.type()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnhancedImageScanFinding").add("AwsAccountId", awsAccountId()).add("Description", description())
                .add("FindingArn", findingArn()).add("FirstObservedAt", firstObservedAt())
                .add("LastObservedAt", lastObservedAt()).add("PackageVulnerabilityDetails", packageVulnerabilityDetails())
                .add("Remediation", remediation()).add("Resources", hasResources() ? resources() : null).add("Score", score())
                .add("ScoreDetails", scoreDetails()).add("Severity", severity()).add("Status", status()).add("Title", title())
                .add("Type", type()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "findingArn":
            return Optional.ofNullable(clazz.cast(findingArn()));
        case "firstObservedAt":
            return Optional.ofNullable(clazz.cast(firstObservedAt()));
        case "lastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "packageVulnerabilityDetails":
            return Optional.ofNullable(clazz.cast(packageVulnerabilityDetails()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "score":
            return Optional.ofNullable(clazz.cast(score()));
        case "scoreDetails":
            return Optional.ofNullable(clazz.cast(scoreDetails()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnhancedImageScanFinding, T> g) {
        return obj -> g.apply((EnhancedImageScanFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnhancedImageScanFinding> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the image.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID associated with the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the finding.
         * </p>
         * 
         * @param findingArn
         *        The Amazon Resource Number (ARN) of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingArn(String findingArn);

        /**
         * <p>
         * The date and time that the finding was first observed.
         * </p>
         * 
         * @param firstObservedAt
         *        The date and time that the finding was first observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstObservedAt(Instant firstObservedAt);

        /**
         * <p>
         * The date and time that the finding was last observed.
         * </p>
         * 
         * @param lastObservedAt
         *        The date and time that the finding was last observed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(Instant lastObservedAt);

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * 
         * @param packageVulnerabilityDetails
         *        An object that contains the details of a package vulnerability finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails);

        /**
         * <p>
         * An object that contains the details of a package vulnerability finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVulnerabilityDetails.Builder}
         * avoiding the need to create one manually via {@link PackageVulnerabilityDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageVulnerabilityDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #packageVulnerabilityDetails(PackageVulnerabilityDetails)}.
         * 
         * @param packageVulnerabilityDetails
         *        a consumer that will call methods on {@link PackageVulnerabilityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVulnerabilityDetails(PackageVulnerabilityDetails)
         */
        default Builder packageVulnerabilityDetails(Consumer<PackageVulnerabilityDetails.Builder> packageVulnerabilityDetails) {
            return packageVulnerabilityDetails(PackageVulnerabilityDetails.builder().applyMutation(packageVulnerabilityDetails)
                    .build());
        }

        /**
         * <p>
         * An object that contains the details about how to remediate a finding.
         * </p>
         * 
         * @param remediation
         *        An object that contains the details about how to remediate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(Remediation remediation);

        /**
         * <p>
         * An object that contains the details about how to remediate a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Remediation.Builder} avoiding the need to
         * create one manually via {@link Remediation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Remediation.Builder#build()} is called immediately and its result
         * is passed to {@link #remediation(Remediation)}.
         * 
         * @param remediation
         *        a consumer that will call methods on {@link Remediation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remediation(Remediation)
         */
        default Builder remediation(Consumer<Remediation.Builder> remediation) {
            return remediation(Remediation.builder().applyMutation(remediation).build());
        }

        /**
         * <p>
         * Contains information on the resources involved in a finding.
         * </p>
         * 
         * @param resources
         *        Contains information on the resources involved in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * Contains information on the resources involved in a finding.
         * </p>
         * 
         * @param resources
         *        Contains information on the resources involved in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);

        /**
         * <p>
         * Contains information on the resources involved in a finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Resource>.Builder} avoiding the need
         * to create one manually via {@link List<Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Resource>.Builder#build()} is called immediately and its
         * result is passed to {@link #resources(List<Resource>)}.
         * 
         * @param resources
         *        a consumer that will call methods on {@link List<Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(List<Resource>)
         */
        Builder resources(Consumer<Resource.Builder>... resources);

        /**
         * <p>
         * The Amazon Inspector score given to the finding.
         * </p>
         * 
         * @param score
         *        The Amazon Inspector score given to the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Double score);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * 
         * @param scoreDetails
         *        An object that contains details of the Amazon Inspector score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreDetails(ScoreDetails scoreDetails);

        /**
         * <p>
         * An object that contains details of the Amazon Inspector score.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScoreDetails.Builder} avoiding the need
         * to create one manually via {@link ScoreDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScoreDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #scoreDetails(ScoreDetails)}.
         * 
         * @param scoreDetails
         *        a consumer that will call methods on {@link ScoreDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoreDetails(ScoreDetails)
         */
        default Builder scoreDetails(Consumer<ScoreDetails.Builder> scoreDetails) {
            return scoreDetails(ScoreDetails.builder().applyMutation(scoreDetails).build());
        }

        /**
         * <p>
         * The severity of the finding.
         * </p>
         * 
         * @param severity
         *        The severity of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(String severity);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The title of the finding.
         * </p>
         * 
         * @param title
         *        The title of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The type of the finding.
         * </p>
         * 
         * @param type
         *        The type of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The date and time the finding was last updated at.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the finding was last updated at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String description;

        private String findingArn;

        private Instant firstObservedAt;

        private Instant lastObservedAt;

        private PackageVulnerabilityDetails packageVulnerabilityDetails;

        private Remediation remediation;

        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private Double score;

        private ScoreDetails scoreDetails;

        private String severity;

        private String status;

        private String title;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedImageScanFinding model) {
            awsAccountId(model.awsAccountId);
            description(model.description);
            findingArn(model.findingArn);
            firstObservedAt(model.firstObservedAt);
            lastObservedAt(model.lastObservedAt);
            packageVulnerabilityDetails(model.packageVulnerabilityDetails);
            remediation(model.remediation);
            resources(model.resources);
            score(model.score);
            scoreDetails(model.scoreDetails);
            severity(model.severity);
            status(model.status);
            title(model.title);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFindingArn() {
            return findingArn;
        }

        public final void setFindingArn(String findingArn) {
            this.findingArn = findingArn;
        }

        @Override
        public final Builder findingArn(String findingArn) {
            this.findingArn = findingArn;
            return this;
        }

        public final Instant getFirstObservedAt() {
            return firstObservedAt;
        }

        public final void setFirstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
        }

        @Override
        public final Builder firstObservedAt(Instant firstObservedAt) {
            this.firstObservedAt = firstObservedAt;
            return this;
        }

        public final Instant getLastObservedAt() {
            return lastObservedAt;
        }

        public final void setLastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(Instant lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final PackageVulnerabilityDetails.Builder getPackageVulnerabilityDetails() {
            return packageVulnerabilityDetails != null ? packageVulnerabilityDetails.toBuilder() : null;
        }

        public final void setPackageVulnerabilityDetails(PackageVulnerabilityDetails.BuilderImpl packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails != null ? packageVulnerabilityDetails.build() : null;
        }

        @Override
        public final Builder packageVulnerabilityDetails(PackageVulnerabilityDetails packageVulnerabilityDetails) {
            this.packageVulnerabilityDetails = packageVulnerabilityDetails;
            return this;
        }

        public final Remediation.Builder getRemediation() {
            return remediation != null ? remediation.toBuilder() : null;
        }

        public final void setRemediation(Remediation.BuilderImpl remediation) {
            this.remediation = remediation != null ? remediation.build() : null;
        }

        @Override
        public final Builder remediation(Remediation remediation) {
            this.remediation = remediation;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder>... resources) {
            resources(Stream.of(resources).map(c -> Resource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getScore() {
            return score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final ScoreDetails.Builder getScoreDetails() {
            return scoreDetails != null ? scoreDetails.toBuilder() : null;
        }

        public final void setScoreDetails(ScoreDetails.BuilderImpl scoreDetails) {
            this.scoreDetails = scoreDetails != null ? scoreDetails.build() : null;
        }

        @Override
        public final Builder scoreDetails(ScoreDetails scoreDetails) {
            this.scoreDetails = scoreDetails;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnhancedImageScanFinding build() {
            return new EnhancedImageScanFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
